/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class SliderFieldEditor
extends FieldEditor {
    private static final String SLIDER_LABEL_DEFAULT_TEXT = "50% ";
    private static final String SLIDER_LABEL_MAX_SIZE_TEXT = "100% ";
    private static final int MAX_SLIDER_VALUE = 1000;
    private static final int MIN_SLIDER_VALUE = 0;
    private static final int INCREMENT_SLIDER_VALUE = 10;
    private static final int DEFAULT_SLIDER_VALUE = 500;
    private Composite sliderComposite;
    private Label sliderLabel;
    private Slider slider;
    private int value;

    public SliderFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            if (this.sliderComposite != null) {
                ((GridData)this.sliderComposite.getLayoutData()).horizontalSpan = left;
            }
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            if (this.sliderComposite != null) {
                ((GridData)this.sliderComposite.getLayoutData()).horizontalSpan = 1;
            }
        }
    }

    protected void createControl(Composite parent) {
        this.doFillIntoGrid(parent, 2);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int sliderSpan = 1;
        if (numColumns > 1) {
            sliderSpan = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getSliderComposite(parent);
        gd = new GridData();
        gd.horizontalSpan = sliderSpan;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateSliderForValue(this.getPreferenceStore().getInt(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateSliderForValue(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.value < 0) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Composite getSliderComposite(Composite parent) {
        if (this.sliderComposite == null) {
            this.sliderComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 8;
            this.sliderComposite.setLayout((Layout)gridLayout);
            GridData gd = new GridData(4, 0, true, false, 1, 1);
            this.sliderComposite.setLayoutData((Object)gd);
            this.sliderLabel = new Label(this.sliderComposite, 0);
            gd = new GridData(16384, 0, false, false, 1, 1);
            this.sliderLabel.setLayoutData((Object)gd);
            this.sliderLabel.setText(SLIDER_LABEL_MAX_SIZE_TEXT);
            Point size = this.sliderLabel.computeSize(-1, -1);
            this.sliderLabel.setSize(size);
            this.sliderLabel.setText(SLIDER_LABEL_DEFAULT_TEXT);
            this.slider = new Slider(this.sliderComposite, 256);
            gd = new GridData(4, 0, true, false, 1, 1);
            this.slider.setLayoutData((Object)gd);
            this.slider.setMaximum(1000 + this.slider.getThumb());
            this.slider.setMinimum(0);
            this.slider.setIncrement(10);
            this.slider.setSelection(500);
            this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SliderFieldEditor.this.updateSlider();
                }
            });
        }
        return this.sliderComposite;
    }

    private void updateSlider() {
        int oldValue = this.value;
        this.value = this.slider.getSelection();
        if (oldValue != this.value) {
            this.setPresentsDefaultValue(false);
            String weightsString = this.value / 10 + "%";
            this.slider.setToolTipText(weightsString);
            this.sliderLabel.setText(weightsString);
            this.fireValueChanged("field_editor_value", oldValue, this.value);
        }
    }

    private void updateSliderForValue(int value) {
        if (this.slider != null) {
            String weightsString = value / 10 + "%";
            this.value = value;
            this.slider.setSelection(value);
            this.slider.setToolTipText(weightsString);
            this.sliderLabel.setText(weightsString);
        }
    }
}

