/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.asf.DirectoryScanner;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;

public class DirectoryScannerFactory {
    public static DirectoryScannerExtension createDirectoryScanner(IArchiveStandardFileSet fs, boolean scan) {
        return DirectoryScannerFactory.createDirectoryScanner(fs.getRawSourcePath(), fs.getRootArchiveRelativePath(), fs.getIncludesPattern(), fs.getExcludesPattern(), fs.getProjectName(), fs.isInWorkspace(), fs.getDescriptorVersion(), scan);
    }

    public static DirectoryScannerExtension createDirectoryScanner(String rawPath, IPath rootArchiveRelativePath, String includes, String excludes, String projectName, boolean inWorkspace, double version, boolean scan) {
        ScannableFileSet fs = new ScannableFileSet();
        fs.rawPath = rawPath;
        fs.rootArchiveRelativePath = rootArchiveRelativePath;
        fs.includes = includes;
        fs.excludes = excludes;
        fs.inWorkspace = inWorkspace;
        fs.projectName = projectName;
        fs.version = version;
        DirectoryScannerExtension scanner = new DirectoryScannerExtension(fs);
        if (scan) {
            try {
                scanner.scan();
            }
            catch (IllegalStateException ise) {
                Status status = new Status(2, "org.jboss.ide.eclipse.archives.core", ise.getMessage(), (Throwable)ise);
                ArchivesCore.getInstance().getLogger().log((IStatus)status);
            }
        }
        return scanner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectoryScannerExtension
    extends DirectoryScanner {
        protected boolean workspaceRelative;
        protected ScannableFileSet fs;
        protected ArrayList<FileWrapper> matches;
        protected HashMap<String, ArrayList<FileWrapper>> matchesMap;

        public DirectoryScannerExtension(ScannableFileSet fs) {
            this.fs = fs;
            String includes = fs.includes == null ? "" : fs.includes;
            String excludes = fs.excludes == null ? "" : fs.excludes;
            String[] includesList = includes.split(" ?, ?");
            String[] excludesList = excludes.split(" ?, ?");
            this.setExcludes(excludesList);
            this.setIncludes(includesList);
            this.workspaceRelative = fs.inWorkspace;
            this.matches = new ArrayList();
            this.matchesMap = new HashMap();
            this.setBasedir2(fs.rawPath);
        }

        public void setBasedir2(String path) {
            Path translatedPath = new Path(PathUtils.getAbsoluteLocation(path, this.fs.projectName, this.fs.inWorkspace, this.fs.version));
            if (this.workspaceRelative) {
                IPath p = PathUtils.getGlobalLocation(path, this.fs.projectName, true, this.fs.version);
                this.setBasedir(new FileWrapper(p.toFile(), (IPath)translatedPath, this.fs.rootArchiveRelativePath));
            } else {
                this.setBasedir(new FileWrapper(translatedPath.toFile(), (IPath)translatedPath, this.fs.rootArchiveRelativePath));
            }
        }

        @Override
        protected String getName(File file) {
            return this.workspaceRelative ? ((FileWrapper)file).getOutputName() : super.getName(file);
        }

        @Override
        protected File[] list2(File file) {
            if (this.fs.inWorkspace) {
                return this.list2workspace(file);
            }
            return this.list2absolute(file);
        }

        @Override
        protected File getChild(File file, String element) {
            if (!this.fs.inWorkspace) {
                return new FileWrapper(file, (IPath)new Path(file.getAbsolutePath()), this.fs.rootArchiveRelativePath);
            }
            FileWrapper pWrapper = (FileWrapper)file;
            File child = super.getChild(file, element);
            FileWrapper childWrapper = new FileWrapper(child, pWrapper.getWrapperPath().append(element), this.fs.rootArchiveRelativePath);
            return childWrapper;
        }

        protected File[] list2workspace(File file) {
            IPath workspaceRelative = ((FileWrapper)file).getWrapperPath();
            if (workspaceRelative == null) {
                return new File[0];
            }
            IPath[] childrenWorkspace = ArchivesCore.getInstance().getVFS().getWorkspaceChildren(workspaceRelative);
            IPath[] childrenAbsolute = this.globalize(childrenWorkspace);
            File[] files = new File[childrenAbsolute.length];
            int i = 0;
            while (i < files.length) {
                files[i] = new FileWrapper(childrenAbsolute[i].toFile(), childrenWorkspace[i], this.fs.rootArchiveRelativePath);
                ++i;
            }
            return files;
        }

        protected IPath[] globalize(IPath[] paths) {
            IPath[] results = new IPath[paths.length];
            int i = 0;
            while (i < paths.length) {
                results[i] = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(paths[i]);
                ++i;
            }
            return results;
        }

        protected File[] list2absolute(File file) {
            File[] children = file.listFiles();
            if (children != null) {
                File[] children2 = new FileWrapper[children.length];
                int i = 0;
                while (i < children.length) {
                    children2[i] = new FileWrapper(children[i], (IPath)new Path(children[i].getAbsolutePath()), this.fs.rootArchiveRelativePath);
                    ++i;
                }
                return children2;
            }
            return new FileWrapper[0];
        }

        @Override
        protected void postInclude(File f, String relative) {
            super.postInclude(f, relative);
            if (f instanceof FileWrapper) {
                FileWrapper f2 = (FileWrapper)f;
                f2.setFilesetRelative(relative);
                if (f.isFile()) {
                    this.matches.add(f2);
                    ArrayList<FileWrapper> l = this.matchesMap.get(f2);
                    if (l == null) {
                        l = new ArrayList();
                        this.matchesMap.put(((FileWrapper)f).getAbsolutePath(), l);
                    }
                    l.add(f2);
                }
            }
        }

        @Override
        protected boolean isSelected(String name, File file) {
            return super.isSelected(name, file) && file.isFile();
        }

        public FileWrapper[] getMatchedArray() {
            return this.matches.toArray(new FileWrapper[this.matches.size()]);
        }

        public HashMap<String, ArrayList<FileWrapper>> getMatchedMap() {
            return this.matchesMap;
        }

        public boolean couldBeIncluded(String path, boolean inWorkspace) {
            IPath targetBase = ((FileWrapper)this.getBasedir()).getWrapperPath();
            IPath[] questionFiles = new IPath[]{new Path(path)};
            if (this.workspaceRelative && !inWorkspace) {
                questionFiles = ArchivesCore.getInstance().getVFS().absolutePathToWorkspacePath(questionFiles[0]);
            } else if (!this.workspaceRelative && inWorkspace) {
                questionFiles[0] = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(questionFiles[0]);
            }
            ArrayList<IPath> acceptablePaths = new ArrayList<IPath>();
            int i = 0;
            while (i < questionFiles.length) {
                if (targetBase.isPrefixOf(questionFiles[i])) {
                    acceptablePaths.add(questionFiles[i].removeFirstSegments(targetBase.segmentCount()));
                }
                ++i;
            }
            if (acceptablePaths.size() == 0) {
                return false;
            }
            int i2 = 0;
            while (i2 < acceptablePaths.size()) {
                IPath p = (IPath)acceptablePaths.get(i2);
                if (super.isIncluded(p.toString()) && !super.isExcluded(p.toString())) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public static class FileWrapper
        extends File {
            File f;
            IPath path;
            String fsRelative;
            IPath rootArchiveRelativePath;

            public FileWrapper(File delegate, IPath path2, IPath rootArchiveRelative) {
                super(delegate.getAbsolutePath());
                this.f = delegate;
                this.path = path2;
                this.rootArchiveRelativePath = rootArchiveRelative;
            }

            public FileWrapper(File delegate, IPath path2, IPath rootArchiveRelative, String fsRelative) {
                this(delegate, path2, rootArchiveRelative);
                this.fsRelative = fsRelative;
            }

            public IPath getWrapperPath() {
                return this.path;
            }

            public String getOutputName() {
                return this.path.lastSegment();
            }

            public String getFilesetRelative() {
                return this.fsRelative;
            }

            void setFilesetRelative(String s) {
                this.fsRelative = s;
            }

            public IPath getRootArchiveRelative() {
                if (this.rootArchiveRelativePath != null) {
                    return this.rootArchiveRelativePath.append(this.fsRelative);
                }
                return null;
            }

            public boolean equals(Object o) {
                if (o instanceof FileWrapper) {
                    FileWrapper fo = (FileWrapper)o;
                    return this.f.equals(fo.f) && this.path.equals((Object)fo.path);
                }
                return false;
            }
        }
    }

    private static class ScannableFileSet {
        public String rawPath;
        public IPath rootArchiveRelativePath;
        public String includes;
        public String excludes;
        public boolean inWorkspace;
        public String projectName;
        public double version;

        private ScannableFileSet() {
        }
    }
}

