/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class ModelUIImages {
    private static String ACTIONS_PATH = "wizards/";
    public static String ACT_CREATE_PROJECT = String.valueOf(ACTIONS_PATH) + "new_project.gif";
    public static String ACT_ADOPT_PROJECT = String.valueOf(ACTIONS_PATH) + "adopt_project.gif";
    public static String ACT_IMPORT_PROJECT = String.valueOf(ACTIONS_PATH) + "import_project.gif";
    public static String WIZARD_NEW_PROJECT = String.valueOf(ACTIONS_PATH) + "EclipseCreateNewProject.png";
    public static String WIZARD_DEFAULT = String.valueOf(ACTIONS_PATH) + "EclipseDefault.png";
    public static String WIZARD_IMPORT_PROJECT = String.valueOf(ACTIONS_PATH) + "EclipseImport.png";
    public static String WIZARD_MODULES_CONFIG = String.valueOf(ACTIONS_PATH) + "EclipseModulesConfiguration.gif";
    public static String JAVA_CLASS = "java/class.gif";
    public static String JAVA_INTERFACE = "java/interface.gif";
    public static String JAVA_PACKAGE = "java/package.gif";
    private static ModelUIImages INSTANCE;
    private URL baseUrl;
    private ModelUIImages parentRegistry;

    static {
        try {
            INSTANCE = new ModelUIImages(new URL(ModelUIPlugin.getDefault().getBundle().getEntry("/"), "images/xstudio/"));
        }
        catch (MalformedURLException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static Image getImage(String key) {
        if (ModelUIPlugin.isDebugEnabled()) {
            ModelUIPlugin.getPluginLog().logInfo("Create image for key '" + key + "'.");
        }
        return INSTANCE.createImageDescriptor(key).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (ModelUIPlugin.isDebugEnabled()) {
            ModelUIPlugin.getPluginLog().logInfo("Create image descriptor for key '" + key + "'.");
        }
        return INSTANCE.createImageDescriptor(key);
    }

    public static void setImageDescriptors(IAction action, String iconName) {
        action.setImageDescriptor(INSTANCE.createImageDescriptor(iconName));
    }

    public static ModelUIImages getInstance() {
        return INSTANCE;
    }

    protected ModelUIImages(URL registryUrl, ModelUIImages parent) {
        if (ModelUIPlugin.isDebugEnabled()) {
            ModelUIPlugin.getPluginLog().logInfo("Create ModelUIImages class.");
            ModelUIPlugin.getPluginLog().logInfo("RegistryUrl = " + registryUrl);
            ModelUIPlugin.getPluginLog().logInfo("parent = " + (parent == null ? "null" : parent.getClass().getName()));
        }
        if (registryUrl == null) {
            throw new IllegalArgumentException("Base url for image registry cannot be null.");
        }
        this.baseUrl = registryUrl;
        this.parentRegistry = parent;
    }

    protected ModelUIImages(URL url) {
        this(url, null);
    }

    public Image getImageByFileName(String key) {
        return this.createImageDescriptor(key).createImage();
    }

    public ImageDescriptor createImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(key));
        }
        catch (MalformedURLException malformedURLException) {
            if (this.parentRegistry == null) {
                return ImageDescriptor.getMissingImageDescriptor();
            }
            return this.parentRegistry.createImageDescriptor(key);
        }
    }

    private URL makeIconFileURL(String name) throws MalformedURLException {
        if (name == null) {
            throw new MalformedURLException("Image name cannot be null.");
        }
        return new URL(this.baseUrl, name);
    }
}

