/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.adapter.AdapterFactory;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.NoteEditor;
import org.jboss.tools.common.model.ui.attribute.editor.NoteFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorFactory;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditorEx;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAttributeSupport {
    boolean isDebugging = ModelUIPlugin.getDefault().isDebugging();
    private ArrayList<IModelPropertyEditorAdapter> adapters = new ArrayList();
    private ArrayList<PropertyEditor> editors = new ArrayList();
    private Map<String, FieldEditor> fieldEditors = new HashMap<String, FieldEditor>();
    protected Set<String> alwaysGreedy = new HashSet<String>();
    private XModelObject xmo;
    private XEntityData data;
    private Layout layout;
    private IWidgetSettings settings = DefaultSettings.getDefault();
    private boolean enabled = Boolean.TRUE;

    public XAttributeSupport() {
    }

    public XAttributeSupport(IWidgetSettings settings) {
        this.settings = settings;
    }

    public XAttributeSupport(XModelObject xmo) {
        if (xmo == null) {
            throw new IllegalArgumentException("XModelObject cannot be null.");
        }
        this.init(xmo);
    }

    public XAttributeSupport(XModelObject xmo, XEntityData data) {
        this(xmo, data, false);
    }

    public XAttributeSupport(XModelObject xmo, XEntityData data, boolean useObject) {
        if (data == null) {
            throw new IllegalArgumentException("XEntityData cannot be null.");
        }
        this.init(xmo, data, useObject);
    }

    public XEntityData getEntityData() {
        return this.data;
    }

    public void init(XModelObject xmo, XEntityData data) {
        this.init(xmo, data, false);
    }

    public void init(XModelObject xmo) {
        this.xmo = xmo;
        XAttribute[] attribute = xmo.getModelEntity().getAttributes();
        this.adapters.clear();
        this.editors.clear();
        int i = 0;
        while (i < attribute.length) {
            if (attribute[i].isVisible()) {
                IModelPropertyEditorAdapter adapter = this.createAdapter(xmo, attribute[i]);
                PropertyEditor editor = this.createEditor((Object)adapter, xmo, attribute[i]);
                this.adapters.add(adapter);
                this.editors.add(editor);
                if ("always".equals(attribute[i].getProperty("greedy"))) {
                    this.alwaysGreedy.add(attribute[i].getName());
                }
            }
            ++i;
        }
    }

    public void init(XModelObject xmo, XEntityData data, boolean useObject) {
        this.data = data;
        this.xmo = xmo;
        XAttributeData[] ads = data.getAttributeData();
        this.adapters.clear();
        this.editors.clear();
        int i = 0;
        while (i < ads.length) {
            String labelText;
            PropertyEditor editor;
            XAttribute attr = ads[i].getAttribute();
            IModelPropertyEditorAdapter adapter = useObject ? this.createAdapter(xmo, attr) : this.createAdapter(xmo, ads[i]);
            PropertyEditor propertyEditor = editor = useObject ? this.createEditor((Object)adapter, xmo, attr) : this.createEditor((Object)adapter, xmo, ads[i]);
            if (editor.getLabelText() == null && (labelText = WizardKeys.getAttributeDisplayName((XAttributeData)ads[i])) != null) {
                labelText = String.valueOf(labelText) + (ads[i].getMandatoryFlag() ? "*" : "");
                editor.setLabelText(labelText);
            }
            this.adapters.add(adapter);
            this.editors.add(editor);
            if ("always".equals(attr.getProperty("greedy"))) {
                this.alwaysGreedy.add(attr.getName());
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.editors != null) {
            for (Object object : this.editors) {
                if (!(object instanceof FieldEditor)) continue;
                ((FieldEditor)object).dispose();
            }
            this.editors.clear();
            this.editors = null;
        }
        if (this.adapters != null) {
            for (Object object : this.adapters) {
                if (!(object instanceof DefaultValueAdapter)) continue;
                ((DefaultValueAdapter)object).dispose();
            }
            this.adapters.clear();
            this.adapters = null;
        }
        if (this.fieldEditors != null) {
            this.fieldEditors.clear();
            this.fieldEditors = null;
        }
        if (this.alwaysGreedy != null) {
            this.alwaysGreedy.clear();
            this.alwaysGreedy = null;
        }
        this.xmo = null;
        this.settings = null;
    }

    private IModelPropertyEditorAdapter createAdapter(XModelObject o, XAttribute a) {
        return AdapterFactory.getAdapter(a, o, o.getModel());
    }

    private IModelPropertyEditorAdapter createAdapter(XModelObject o, XAttributeData a) {
        return AdapterFactory.getAdapter(a.getAttribute(), o, a, o.getModel());
    }

    private PropertyEditor createEditor(Object adapter, XModelObject o, XAttribute a) {
        return PropertyEditorFactory.createPropertyEditor(adapter, a, o, this.settings);
    }

    private PropertyEditor createEditor(Object adapter, XModelObject o, XAttributeData a) {
        return PropertyEditorFactory.createPropertyEditor(adapter, a.getAttribute(), a, this.settings);
    }

    public void setAutoStore(boolean set) {
        for (IModelPropertyEditorAdapter element : this.adapters) {
            element.setAutoStore(set);
        }
    }

    public Control[] fillComposite(Composite composite, PropertyEditor editor, StringButtonFieldEditorEx sb) {
        composite.setBackgroundMode(1);
        ExtendedFieldEditor fieldEditor = null;
        boolean greedy = editor.isGreedyEditor();
        if (!greedy) {
            fieldEditor = editor.getFieldEditor(composite);
        } else {
            if (sb == null) {
                sb = new StringButtonFieldEditorEx(this.settings);
            }
            sb.setLabelText(editor.getLabelText());
            sb.setPropertyEditor(editor);
            String changeButtonName = editor.getChangeButtonName();
            if (changeButtonName != null) {
                sb.setChangeButtonText(changeButtonName);
            }
            fieldEditor = sb;
            greedy = false;
        }
        this.registerFieldEditor(editor.getAttributeName(), fieldEditor);
        if (!this.enabled) {
            fieldEditor.setEnabled(this.enabled);
        }
        Control[] controls = this.fillComposite(composite, fieldEditor, greedy);
        if (fieldEditor instanceof StringButtonFieldEditorEx) {
            ((StringButtonFieldEditorEx)fieldEditor).setStringValue("" + editor.getValue());
        }
        return controls;
    }

    public Control[] fillComposite(Composite composite, FieldEditor fieldEditor, boolean greedy) {
        composite.setBackgroundMode(1);
        if (fieldEditor instanceof IFieldEditor) {
            Control[] controls = ((IFieldEditor)fieldEditor).getControls(composite);
            if (controls.length == 2) {
                Control control = controls[0];
                GridData gd = new GridData();
                control.setLayoutData((Object)gd);
                control = controls[1];
                if (greedy) {
                    gd.verticalAlignment = 1;
                    if (this.editors.size() == 1) {
                        gd.horizontalSpan = 2;
                    }
                    gd = new GridData(1808);
                    if (this.editors.size() == 1) {
                        gd.horizontalSpan = 2;
                    }
                } else {
                    gd = new GridData(768);
                }
                if (greedy) {
                    int h = control.computeSize((int)-1, (int)-1).y;
                    if (h > 300) {
                        gd.heightHint = 300;
                    }
                    if (fieldEditor instanceof NoteFieldEditor) {
                        gd.heightHint = 100;
                    }
                }
                control.setLayoutData((Object)gd);
            } else if (controls.length == 1) {
                Control control = controls[0];
                GridData gd = new GridData(768);
                gd.horizontalSpan = 2;
                control.setLayoutData((Object)gd);
            }
            return controls;
        }
        fieldEditor.fillIntoGrid(composite, 2);
        return null;
    }

    public void fillComposite(Composite composite) {
        PropertyEditor editor;
        composite.setBackgroundMode(1);
        int greedyCount = 0;
        this.sortEditors();
        int i = 0;
        while (i < this.editors.size()) {
            editor = this.editors.get(i);
            if (editor.isGreedyEditor()) {
                ++greedyCount;
            }
            ++i;
        }
        i = 0;
        while (i < this.editors.size()) {
            editor = this.editors.get(i);
            ExtendedFieldEditor fieldEditor = null;
            boolean greedy = editor.isGreedyEditor();
            if (!greedy || this.keepGreedy(editor.getAttributeName(), i, greedyCount) || editor instanceof NoteEditor) {
                fieldEditor = editor.getFieldEditor(composite);
            } else {
                StringButtonFieldEditorEx sb = new StringButtonFieldEditorEx(this.settings);
                sb.setLabelText(editor.getLabelText());
                sb.setPropertyEditor(editor);
                String changeButtonName = editor.getChangeButtonName();
                if (changeButtonName != null) {
                    sb.setChangeButtonText(changeButtonName);
                }
                fieldEditor = sb;
                greedy = false;
            }
            this.registerFieldEditor(editor.getAttributeName(), fieldEditor);
            if (!this.enabled) {
                fieldEditor.setEnabled(this.enabled);
            }
            this.fillComposite(composite, fieldEditor, greedy);
            if (fieldEditor instanceof StringButtonFieldEditorEx) {
                ((StringButtonFieldEditorEx)fieldEditor).setStringValue("" + editor.getValue());
            }
            ++i;
        }
    }

    private void sortEditors() {
        PropertyEditor editor = null;
        int i = 0;
        while (i < this.editors.size()) {
            editor = this.editors.get(i);
            if ("description".equalsIgnoreCase(editor.getAttributeName())) {
                this.editors.remove(editor);
                this.editors.add(editor);
                return;
            }
            ++i;
        }
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(this.getLayout());
        this.fillComposite(composite);
        return composite;
    }

    protected boolean keepGreedy(String name, int index, int greedyCount) {
        return greedyCount < 1 || greedyCount == 1 && this.editors.size() < 2 || this.alwaysGreedy.contains(name);
    }

    public void store() {
        int i = 0;
        while (i < this.editors.size()) {
            this.adapters.get(i).store();
            ++i;
        }
    }

    public void load() {
        if (this.xmo == null) {
            throw new IllegalArgumentException("Init support with XModelObject before saving");
        }
        int i = 0;
        while (i < this.editors.size()) {
            this.adapters.get(i).load();
            ++i;
        }
    }

    public void save() {
        if (this.xmo == null) {
            throw new IllegalArgumentException("Init support with XModelObject before saving");
        }
        if (this.xmo.getModel() == null) {
            throw new IllegalArgumentException("Cannot store deleted or removed XModel object");
        }
        this.xmo.getModel().saveOptions();
    }

    public List getAdapterList() {
        return Collections.unmodifiableList(this.adapters);
    }

    public List<FieldEditor> getVisibleFieldEditors() {
        ArrayList<FieldEditor> visibleEditors = new ArrayList<FieldEditor>();
        Set<String> keySet = this.fieldEditors.keySet();
        Iterator<String> i = keySet.iterator();
        while (i.hasNext()) {
            visibleEditors.add(this.fieldEditors.get(i.next()));
        }
        return visibleEditors;
    }

    public List getEditorList() {
        return Collections.unmodifiableList(this.editors);
    }

    public String getTitle() {
        return this.xmo.getPresentationString();
    }

    public IPropertyEditor getPropertyEditorByName(String attributeName) {
        IPropertyEditor result = null;
        if (attributeName != null && !"".equals(attributeName)) {
            Iterator<PropertyEditor> iterator = this.editors.iterator();
            while (iterator.hasNext() && result == null) {
                IPropertyEditor editor = iterator.next();
                if (!attributeName.equals(editor.getAttributeName())) continue;
                result = editor;
            }
        }
        return result;
    }

    public FieldEditor getFieldEditorByName(String attributeName) {
        return this.fieldEditors.get(attributeName);
    }

    public void registerFieldEditor(String attributeName, FieldEditor f) {
        if (f != null) {
            this.fieldEditors.put(attributeName, f);
        }
    }

    public IModelPropertyEditorAdapter getPropertyEditorAdapterByName(String attributeName) {
        IModelPropertyEditorAdapter result = null;
        if (attributeName != null && !"".equals(attributeName)) {
            Iterator<IModelPropertyEditorAdapter> iterator = this.adapters.iterator();
            while (iterator.hasNext() && result == null) {
                IModelPropertyEditorAdapter adapter = iterator.next();
                if (!attributeName.equals(adapter.getAttribute().getName())) continue;
                result = adapter;
            }
        }
        return result;
    }

    public Layout getLayout() {
        if (this.layout == null) {
            this.layout = this.getDefaultLayout();
        }
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    protected Layout getDefaultLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        return gridLayout;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        int i = 0;
        while (i < this.adapters.size()) {
            IModelPropertyEditorAdapter a = this.adapters.get(i);
            a.addValueChangeListener(listener);
            ++i;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        int i = 0;
        while (i < this.adapters.size()) {
            IModelPropertyEditorAdapter a = this.adapters.get(i);
            a.removeValueChangeListener(listener);
            ++i;
        }
    }

    public Properties getValues() {
        Properties p = new Properties();
        if (this.data == null) {
            return p;
        }
        XAttributeData[] ads = this.data.getAttributeData();
        int i = 0;
        while (i < this.adapters.size()) {
            IModelPropertyEditorAdapter a = this.adapters.get(i);
            Object v = a.getValue();
            if (v != null) {
                XAttribute att = ads[i].getAttribute();
                String value = v.toString();
                if (att.isTrimmable()) {
                    value = value.trim();
                }
                p.setProperty(att.getName(), value);
            }
            ++i;
        }
        return p;
    }

    public IWidgetSettings getSettings() {
        return this.settings;
    }

    public void setSettings(IWidgetSettings settings) {
        this.settings = settings;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        this.doSetEnabled();
    }

    protected void doSetEnabled() {
        if (this.fieldEditors != null) {
            Collection<FieldEditor> fieldEditros = this.fieldEditors.values();
            Iterator<FieldEditor> i = fieldEditros.iterator();
            while (i.hasNext()) {
                ((ExtendedFieldEditor)i.next()).setEnabled(this.enabled);
            }
        }
    }

    public void updateEnablementByModelObject() {
        Iterator<String> it = this.fieldEditors.keySet().iterator();
        while (it.hasNext()) {
            String n = it.next().toString();
            ExtendedFieldEditor f = (ExtendedFieldEditor)this.fieldEditors.get(n);
            f.setEnabled(this.xmo.isAttributeEditable(n));
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (this.getVisibleFieldEditors() == null) {
            return false;
        }
        for (ExtendedFieldEditor extendedFieldEditor : this.getVisibleFieldEditors()) {
            if (ActionFactory.CUT.getId().equals(actionId)) {
                extendedFieldEditor.cut();
                continue;
            }
            if (ActionFactory.COPY.getId().equals(actionId)) {
                extendedFieldEditor.copy();
                continue;
            }
            if (ActionFactory.PASTE.getId().equals(actionId)) {
                extendedFieldEditor.paste();
                continue;
            }
            if (!ActionFactory.DELETE.getId().equals(actionId)) continue;
            extendedFieldEditor.delete();
        }
        return false;
    }
}

