/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package com.metamatrix.vdb.edit;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;


/** 
 * This interface defines the options for WSDL generation within the context of 
 * a Virtual Database definition file.
 * @see com.metamatrix.vdb.edit.VdbEditingContext#getVdbWsdlGenerationOptions()
 * @since 4.2
 */
public interface VdbWsdlGenerationOptions {
    
    /**
     * Return whether WSDL can be generated.  This method returns true only if
     * there is at least one {@link com.metamatrix.metamodels.webservice.WebServicePackage Web Service}
     * model in the VDB.
     * @return true if the VDB contains files that can be used to generate WSDL, or false otherwise.
     * @since 4.2
     */
    public boolean canWsdlBeGenerated();
    
    public String getTargetNamespaceUri();
    
    public void setTargetNamespaceUri(String namespaceUri);
    
    public String[] getAllNamespaceUris() throws ModelWorkspaceException;
    
    public String getDefaultNamespaceUri();
    
    public void setDefaultNamespaceUri(String namespaceUri);
    
    public List getWebServiceModelReferences();
    
    /**
     * Utility method to determine whether a supplied string is a valid URI. 
     * @param str the string value; may not be null
     * @return true if the string contains a valid URI, or false otherwise.
     * @since 4.2
     */
    public boolean isValidUri( final String str );
    
    /**
     * Preview the WSDL that will be generated by obtaining an input stream.
     * @param monitor
     * @return
     * @throws IOException if there is a problem accessing the generated WSDL
     * @throws VdbEditException if the WSDL cannot be generated
     * @since 4.2
     */
    public InputStream getWsdl( final IProgressMonitor monitor ) throws IOException, VdbEditException;
    
    /**
     * Preview the WSDL that will be generated.
     * @param monitor
     * @return
     * @throws IOException if there is a problem accessing the generated WSDL
     * @throws VdbEditException if the WSDL cannot be generated
     * @since 4.2
     */
    public String getWsdlAsString( final IProgressMonitor monitor ) throws IOException, VdbEditException;
}
