/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import name.herlin.command.Timer;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.MarkerInfo;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;

public class BaseVisitor {
    private static final Logger log;
    private IProgressMonitor monitor;
    private boolean useTaskMarker = false;
    private Map accumulator;
    private PMD pmdEngine;
    private RuleSet ruleSet;
    private int filesCount;
    private long pmdDuration;
    private IProjectProperties projectProperties;
    protected RuleSet hiddenRules = new RuleSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.BaseVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    protected BaseVisitor() {
    }

    public boolean isUseTaskMarker() {
        return this.useTaskMarker;
    }

    public void setUseTaskMarker(boolean bl) {
        this.useTaskMarker = bl;
    }

    public Map getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(Map map) {
        this.accumulator = map;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public boolean isCanceled() {
        return this.getMonitor() == null ? false : this.getMonitor().isCanceled();
    }

    public void subTask(String string) {
        if (this.getMonitor() != null) {
            this.getMonitor().subTask(string);
        }
    }

    public void worked(int n) {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(n);
        }
    }

    public PMD getPmdEngine() {
        return this.pmdEngine;
    }

    public void setPmdEngine(PMD pMD) {
        this.pmdEngine = pMD;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        ruleSet.addRuleSet(this.hiddenRules);
        this.ruleSet = ruleSet;
    }

    public int getProcessedFilesCount() {
        return this.filesCount;
    }

    public long getActualPmdDuration() {
        return this.pmdDuration;
    }

    public void setProjectProperties(IProjectProperties iProjectProperties) {
        this.projectProperties = iProjectProperties;
    }

    protected final void reviewResource(IResource iResource) {
        IFile iFile;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iFile = (IFile)iResource.getAdapter((Class)clazz)) != null && iFile.getFileExtension() != null && iFile.getFileExtension().equals("java")) {
            try {
                boolean bl = this.projectProperties.isIncludeDerivedFiles() || !this.projectProperties.isIncludeDerivedFiles() && !iFile.isDerived();
                log.debug((Object)("Derived files included: " + this.projectProperties.isIncludeDerivedFiles()));
                log.debug((Object)("file " + iFile.getName() + " is derived: " + iFile.isDerived()));
                log.debug((Object)("file checked: " + bl));
                if (this.isFileInWorkingSet(iFile) && (this.projectProperties.isIncludeDerivedFiles() || !this.projectProperties.isIncludeDerivedFiles() && !iFile.isDerived())) {
                    this.subTask("PMD Checking file " + iFile.getName());
                    Timer timer = new Timer();
                    RuleContext ruleContext = new RuleContext();
                    ruleContext.setSourceCodeFile(iFile.getRawLocation().toFile());
                    ruleContext.setSourceCodeFilename(iFile.getName());
                    ruleContext.setReport(new Report());
                    InputStreamReader inputStreamReader = new InputStreamReader(iFile.getContents(), iFile.getCharset());
                    this.getPmdEngine().processFile((Reader)inputStreamReader, this.getRuleSet(), ruleContext);
                    ((Reader)inputStreamReader).close();
                    timer.stop();
                    this.pmdDuration += timer.getDuration();
                    this.updateMarkers(iFile, ruleContext, this.isUseTaskMarker(), this.getAccumulator());
                    this.worked(1);
                    ++this.filesCount;
                } else {
                    log.debug((Object)("The file " + iFile.getName() + " is not in the working set"));
                }
            }
            catch (CoreException coreException) {
                log.error((Object)("Core exception visiting " + iFile.getName()), (Throwable)coreException);
            }
            catch (PMDException pMDException) {
                log.error((Object)("PMD exception visiting " + iFile.getName()), (Throwable)pMDException);
            }
            catch (IOException iOException) {
                log.error((Object)("IO exception visiting " + iFile.getName()), (Throwable)iOException);
            }
            catch (PropertiesException propertiesException) {
                log.error((Object)("Properties exception visiting " + iFile.getName()), (Throwable)propertiesException);
            }
        }
    }

    private boolean isFileInWorkingSet(IFile iFile) throws PropertiesException {
        boolean bl = true;
        IWorkingSet iWorkingSet = this.projectProperties.getProjectWorkingSet();
        if (iWorkingSet != null) {
            ResourceWorkingSetFilter resourceWorkingSetFilter = new ResourceWorkingSetFilter();
            resourceWorkingSetFilter.setWorkingSet(iWorkingSet);
            bl = resourceWorkingSetFilter.select(null, null, (Object)iFile);
        }
        return bl;
    }

    private void updateMarkers(IFile iFile, RuleContext ruleContext, boolean bl, Map map) throws CoreException, PropertiesException {
        HashSet<MarkerInfo> hashSet = new HashSet<MarkerInfo>();
        List list = this.findReviewedViolations(iFile);
        Review review = new Review();
        Iterator iterator = ruleContext.getReport().iterator();
        IPreferences iPreferences = PMDPlugin.getDefault().loadPreferences();
        int n = iPreferences.getMaxViolationsPerFilePerRule();
        HashMap<Rule, Integer> hashMap = new HashMap<Rule, Integer>();
        while (iterator.hasNext()) {
            RuleViolation ruleViolation = (RuleViolation)iterator.next();
            review.ruleName = ruleViolation.getRule().getName();
            review.lineNumber = ruleViolation.getBeginLine();
            if (list.contains(review)) {
                log.debug((Object)("Ignoring violation of rule " + ruleViolation.getRule().getName() + " at line " + ruleViolation.getBeginLine() + " because of a review."));
                continue;
            }
            Integer n2 = (Integer)hashMap.get(ruleViolation.getRule());
            if (n2 == null) {
                n2 = new Integer(0);
                hashMap.put(ruleViolation.getRule(), n2);
            }
            int n3 = n;
            if (ruleViolation.getRule().hasProperty("maxviolations")) {
                n3 = ruleViolation.getRule().getIntProperty("maxviolations");
            }
            if (n2 < n3) {
                hashSet.add(this.getMarkerInfo(ruleViolation, "net.sourceforge.pmd.eclipse.plugin.pmdMarker"));
                hashMap.put(ruleViolation.getRule(), new Integer(n2 + 1));
                log.debug((Object)("Adding a violation for rule " + ruleViolation.getRule().getName() + " at line " + ruleViolation.getBeginLine()));
                continue;
            }
            log.debug((Object)("Ignoring violation of rule " + ruleViolation.getRule().getName() + " at line " + ruleViolation.getBeginLine() + " because maximum violations has been reached for file " + iFile.getName()));
        }
        if (map != null) {
            log.debug((Object)("Adding markerSet to accumulator for file " + iFile.getName()));
            map.put(iFile, hashSet);
        }
    }

    private List findReviewedViolations(IFile iFile) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            Stack<String> stack = new Stack<String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()));
            while (bufferedReader.ready()) {
                Object object;
                String string = bufferedReader.readLine();
                if (string == null) continue;
                string = string.trim();
                ++n;
                if (string.startsWith("/*")) {
                    bl2 = string.indexOf("*/") == -1;
                    continue;
                }
                if (bl2 && string.indexOf("*/") != -1) {
                    bl2 = false;
                    continue;
                }
                if (!bl2 && string.startsWith("// @PMD:REVIEWED:")) {
                    object = string.substring(17);
                    String string2 = ((String)object).substring(0, ((String)object).indexOf(58));
                    stack.push(string2);
                    bl = true;
                    continue;
                }
                if (bl2 || !bl || string.equals("") || string.startsWith("//")) continue;
                bl = false;
                while (!stack.empty()) {
                    object = new Review();
                    ((Review)object).ruleName = (String)stack.pop();
                    ((Review)object).lineNumber = n;
                    arrayList.add(object);
                }
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("Core Exception when searching reviewed violations", coreException);
        }
        catch (IOException iOException) {
            PMDPlugin.getDefault().logError("IO Exception when searching reviewed violations", iOException);
        }
        return arrayList;
    }

    private MarkerInfo getMarkerInfo(RuleViolation ruleViolation, String string) throws PropertiesException {
        MarkerInfo markerInfo = new MarkerInfo();
        markerInfo.setType(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList.add("message");
        arrayList2.add(ruleViolation.getDescription());
        arrayList.add("lineNumber");
        arrayList2.add(new Integer(ruleViolation.getBeginLine()));
        arrayList.add("line2");
        arrayList2.add(new Integer(ruleViolation.getEndLine()));
        arrayList.add("rulename");
        arrayList2.add(ruleViolation.getRule().getName());
        arrayList.add("pmd_priority");
        arrayList2.add(new Integer(ruleViolation.getRule().getPriority()));
        switch (ruleViolation.getRule().getPriority()) {
            case 1: {
                arrayList.add("priority");
                arrayList2.add(new Integer(2));
                arrayList.add("severity");
                arrayList2.add(new Integer(this.projectProperties.violationsAsErrors() ? 2 : 1));
                break;
            }
            case 2: {
                arrayList.add("severity");
                if (this.projectProperties.violationsAsErrors()) {
                    arrayList2.add(new Integer(2));
                    break;
                }
                arrayList2.add(new Integer(1));
                arrayList.add("priority");
                arrayList2.add(new Integer(2));
                break;
            }
            case 5: {
                arrayList.add("severity");
                arrayList2.add(new Integer(0));
                break;
            }
            case 3: {
                arrayList.add("priority");
                arrayList2.add(new Integer(2));
            }
            default: {
                arrayList.add("severity");
                arrayList2.add(new Integer(1));
            }
        }
        markerInfo.setAttributeNames(arrayList.toArray(new String[arrayList.size()]));
        markerInfo.setAttributeValues(arrayList2.toArray());
        return markerInfo;
    }

    private class Review {
        public String ruleName;
        public int lineNumber;

        private Review() {
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Review) {
                Review review = (Review)object;
                bl = this.ruleName.equals(review.ruleName) && this.lineNumber == review.lineNumber;
            }
            return bl;
        }

        public int hashCode() {
            return this.ruleName.hashCode() + this.lineNumber * this.lineNumber;
        }
    }
}

