/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.constant.ConstantAnalysis;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantDataflowFactory
extends AnalysisFactory<ConstantDataflow> {
    public ConstantDataflowFactory() {
        super("constant propagation analysis", ConstantDataflow.class);
    }

    @Override
    public ConstantDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            return null;
        }
        ConstantAnalysis analysis = new ConstantAnalysis(methodGen, this.getDepthFirstSearch(analysisCache, descriptor));
        ConstantDataflow dataflow = new ConstantDataflow(this.getCFG(analysisCache, descriptor), analysis);
        dataflow.execute();
        return dataflow;
    }
}

