/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.HashSet;

public class CalledMethods
extends BytecodeScanningDetector
implements NonReportingDetector {
    boolean emptyArrayOnTOS;
    HashSet<XField> emptyArray = new HashSet();
    HashSet<XField> nonEmptyArray = new HashSet();
    XFactory xFactory = AnalysisContext.currentXFactory();

    public CalledMethods(BugReporter bugReporter) {
    }

    public void sawOpcode(int seen) {
        XField f;
        if (!(seen != 181 && seen != 179 || (f = this.getXFieldOperand()) == null || !f.isFinal() && (f.isProtected() || f.isPublic()))) {
            if (this.emptyArrayOnTOS) {
                this.emptyArray.add(f);
            } else {
                this.nonEmptyArray.add(f);
            }
        }
        boolean bl = this.emptyArrayOnTOS = (seen == 189 || seen == 188 || seen == 197 && this.getIntConstant() == 1) && this.getPrevOpcode(1) == 3;
        if ((seen == 178 || seen == 180) && this.emptyArray.contains(f = this.getXFieldOperand()) && !this.nonEmptyArray.contains(f) && f.isFinal()) {
            this.emptyArrayOnTOS = true;
        }
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ClassDescriptor c = this.getClassDescriptorOperand();
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                if (!subtypes2.isApplicationClass(c)) break;
                this.xFactory.addCalledMethod(this.getMethodDescriptorOperand());
                break;
            }
        }
    }

    public void report() {
        this.emptyArray.removeAll(this.nonEmptyArray);
        for (XField f : this.emptyArray) {
            this.xFactory.addEmptyArrayField(f);
        }
        this.emptyArray.clear();
    }
}

