/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.handlers;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.markers.ResourceMarkers;
import org.jboss.tools.common.model.project.ModelNatureExtension;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveModelNatureHandler
extends AbstractHandler {
    public static String PARAM_CONTRIBUTION = "contribution";

    @Override
    public boolean isEnabled(XModelObject object) {
        if (object == null) {
            return false;
        }
        String nature = this.getNatureDisplayName(object);
        if (nature == null) {
            return false;
        }
        XActionImpl i = (XActionImpl)this.action;
        i.setDisplayName(MessageFormat.format("Remove {0} Capabilities", nature));
        return true;
    }

    private String getNatureDisplayName(XModelObject object) {
        ModelNatureExtension[] es;
        IProject p = EclipseResourceUtil.getProject(object);
        ModelNatureExtension[] modelNatureExtensionArray = es = ModelNatureExtension.getInstances();
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            ModelNatureExtension ext = modelNatureExtensionArray[n2];
            String name = ext.getName();
            if (p != null && p.isAccessible()) {
                try {
                    if (p.hasNature(name)) {
                        return ext.getDisplayName();
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return null;
    }

    private String getNature(XModelObject object) {
        ModelNatureExtension[] es;
        IProject p = EclipseResourceUtil.getProject(object);
        ModelNatureExtension[] modelNatureExtensionArray = es = ModelNatureExtension.getInstances();
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            ModelNatureExtension ext = modelNatureExtensionArray[n2];
            String name = ext.getName();
            if (p != null && p.isAccessible()) {
                try {
                    if (p.hasNature(name)) {
                        return ext.getName();
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        SpecialWizard contribution;
        String nature;
        IProject project = EclipseResourceUtil.getProject(object);
        String string = nature = p == null ? null : p.getProperty("nature");
        if (nature == null) {
            nature = this.getNature(object);
        }
        if (project == null || nature == null) {
            return;
        }
        boolean unregisterWTP = false;
        ServiceDialog dialog = object.getModel().getService();
        Properties pd = new Properties();
        String message = MessageFormat.format("Remove {0} Capabilities from project {1}?", this.getNatureDisplayName(object), project.getName());
        pd.setProperty("message", message);
        String checkBoxMessage = "Remove Dynamic Web Project Capabilities";
        pd.setProperty("checkboxMessage", checkBoxMessage);
        pd.put("checked", Boolean.FALSE);
        if (!dialog.openConfirm(pd)) {
            return;
        }
        SpecialWizard specialWizard = contribution = p == null ? null : (SpecialWizard)p.get(PARAM_CONTRIBUTION);
        if (contribution != null) {
            contribution.setObject(object.getModel());
            contribution.execute();
        }
        Boolean b = (Boolean)pd.get("checked");
        unregisterWTP = b;
        try {
            File f;
            IProjectDescription d = project.getDescription();
            String[] ns = d.getNatureIds();
            String[] ns2 = this.removeNature(ns, nature);
            if (unregisterWTP) {
                ns2 = new String[]{"org.eclipse.jdt.core.javanature"};
            }
            if (ns.length == ns2.length) {
                return;
            }
            if (unregisterWTP) {
                this.unregisterFromServer(object);
                this.clearClassPath(project);
            }
            d.setNatureIds(ns2);
            project.setDescription(d, 1, null);
            if (EclipseResourceUtil.getModelNature(project) != null) {
                return;
            }
            String projectLocation = project.getLocation().toString();
            this.removeFiles(projectLocation, XModelConstants.getWorkspace(object.getModel()));
            if (unregisterWTP && (f = new File(String.valueOf(projectLocation) + "/.settings")).isDirectory()) {
                FileUtil.remove((File)f);
            }
            RemoveModelNatureHandler.clear(object.getModel().getByPath("FileSystems/WEB-INF"));
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new XModelException(e);
        }
    }

    private void removeFiles(String location, String workspace) {
        File f = new File(String.valueOf(location) + "/" + ".settings/org.jboss.tools.jst.web.xml");
        if (f.exists()) {
            f.delete();
        }
    }

    @Override
    public boolean getSignificantFlag(XModelObject object) {
        return false;
    }

    public String[] removeNature(String[] natures, String nature) {
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            if (!natures[i].equals(nature)) {
                l.add(natures[i]);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    public static void clear(XModelObject o) {
        if (o == null || o.getFileType() == 0) {
            return;
        }
        if (o.getFileType() == 1) {
            ResourceMarkers markers = new ResourceMarkers(ResourceMarkers.JST_WEB_PROBLEM, ResourceMarkers.OLD_JST_WEB_PROBLEM);
            markers.setModelObject(o);
            markers.update();
        } else {
            XModelObject[] os = o.getChildren();
            int i = 0;
            while (i < os.length) {
                RemoveModelNatureHandler.clear(os[i]);
                ++i;
            }
        }
    }

    void clearClassPath(IProject project) throws XModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> newClassPath = new ArrayList<IClasspathEntry>(this.getRawClassPath(javaProject));
        Iterator<IClasspathEntry> iterator = newClassPath.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = iterator.next();
            if (entry.getEntryKind() == 5 && entry.getPath().toString().indexOf(".jst.") >= 0) {
                iterator.remove();
                continue;
            }
            if (!project.getFullPath().equals((Object)entry.getPath())) continue;
            iterator.remove();
        }
        IClasspathEntry[] entries = newClassPath.toArray(new IClasspathEntry[newClassPath.size()]);
        if (entries.length != 0) {
            try {
                javaProject.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                throw new XModelException(e);
            }
        }
    }

    private List<IClasspathEntry> getRawClassPath(IJavaProject javaProject) throws XModelException {
        try {
            return Arrays.asList(javaProject.getRawClasspath());
        }
        catch (JavaModelException e) {
            throw new XModelException(e);
        }
    }

    void unregisterFromServer(XModelObject object) {
        XModelObject fs = FileSystemsHelper.getFileSystems(object.getModel());
        XAction action = XActionInvoker.getAction("Registration.UnregisterInServerXML", fs);
        if (action != null) {
            Properties runningProperties = new Properties();
            runningProperties.setProperty("unregisterFromAllServers", "true");
            runningProperties.setProperty("showResult", "false");
            XActionInvoker.invoke("Registration.UnregisterInServerXML", fs, runningProperties);
        }
    }
}

