/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.icons.impl;

import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.icons.XIconList;
import org.jboss.tools.common.model.icons.impl.ImageComponent;

public class ModifiersIcon
implements ImageComponent {
    public static Image ABS;
    public static Image FIN;
    public static Image PBC;
    public static Image PLC;
    public static Image PTC;
    public static Image PVC;
    public static Image PBS;
    public static Image PLS;
    public static Image PTS;
    public static Image PVS;
    public static Image[] MOD;
    public static Image[] MOD_S;
    public static Image[] MOD_A;
    public static Image[] MOD_F;
    public static Image[] MOD_SA;
    public static Image[] MOD_SF;

    static {
        XIconList list = XModelMetaDataImpl.getInstance().getIconList();
        ABS = list.getImage("modifiers.abstract");
        FIN = list.getImage("modifiers.final");
        PBC = list.getImage("modifiers.public");
        PTC = list.getImage("modifiers.protected");
        PLC = list.getImage("modifiers.package_local");
        PVC = list.getImage("modifiers.private");
        PBS = list.getImage("modifiers.public_static");
        PTS = list.getImage("modifiers.protected_static");
        PLS = list.getImage("modifiers.package_local_static");
        PVS = list.getImage("modifiers.private_static");
        MOD = new Image[]{PBC, PLC, PTC, PVC};
        MOD_S = new Image[]{ModifiersIcon.add(PBC, PBS), ModifiersIcon.add(PLC, PLS), ModifiersIcon.add(PTC, PTS), ModifiersIcon.add(PVC, PVS)};
        MOD_A = new Image[4];
        MOD_F = new Image[4];
        MOD_SA = new Image[4];
        MOD_SF = new Image[4];
        int i = 0;
        while (i < 4) {
            ModifiersIcon.MOD_A[i] = ModifiersIcon.add(ABS, MOD[i]);
            ModifiersIcon.MOD_F[i] = ModifiersIcon.add(FIN, MOD[i]);
            ModifiersIcon.MOD_SA[i] = ModifiersIcon.add(ABS, MOD_S[i]);
            ModifiersIcon.MOD_SF[i] = ModifiersIcon.add(FIN, MOD_S[i]);
            ++i;
        }
    }

    static Image add(Image front, Image back) {
        if (front != null) {
            return front;
        }
        return back;
    }

    public int getHash(XModelObject obj) {
        if (!this.isShowingModifiers(obj)) {
            return 0;
        }
        String mod = obj.getAttributeValue("modifiers");
        return mod == null ? 0 : mod.hashCode();
    }

    public Image getImage(XModelObject obj) {
        boolean isStatic;
        if (!this.isShowingModifiers(obj)) {
            return null;
        }
        String mod = obj.getAttributeValue("modifiers");
        int access = mod.indexOf("public") >= 0 ? 0 : (mod.indexOf("protected") >= 0 ? 2 : (mod.indexOf("private") >= 0 ? 3 : 1));
        boolean bl = isStatic = mod.indexOf("static") >= 0;
        int override = mod.indexOf("final") >= 0 ? 1 : (mod.indexOf("abstract") >= 0 ? 2 : 0);
        return this.getModifiersIcon(access, isStatic, override);
    }

    private boolean isShowingModifiers(XModelObject obj) {
        XModelObject o = obj.getModel().getRoot("Preferences");
        return o == null ? true : "yes".equals(o.getAttributeValue("show modifiers"));
    }

    private Image getModifiersIcon(int access, boolean isStatic, int override) {
        return isStatic ? this.getStaticIcon(access, override) : this.getNonStaticIcon(access, override);
    }

    private Image getStaticIcon(int i, int override) {
        return override == 1 ? MOD_SF[i] : (override == 2 ? MOD_SA[i] : MOD_S[i]);
    }

    private Image getNonStaticIcon(int i, int override) {
        return override == 1 ? MOD_F[i] : (override == 2 ? MOD_A[i] : MOD[i]);
    }
}

