/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.eclipse.console.model.IRevEngColumn;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.eclipse.mapper.editors.reveng.FormTextEntryListenerAdapter;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.FormTextEntry;

public class ColumnDetailsPage
extends RevEngDetailsPage
implements IDetailsPage,
PropertyChangeListener {
    private FormTextEntry nameEntry;
    private FormTextEntry jdbcTypeEntry;
    private FormTextEntry propertyEntry;
    private FormTextEntry typeEntry;
    private IRevEngColumn column;

    public void buildContents(FormToolkit toolkit, Section section, Composite client) {
        section.setText(MapperMessages.ColumnDetailsPage_column_details);
        section.setDescription(MapperMessages.ColumnDetailsPage_set_properties_of_selected_column);
        this.nameEntry = new FormTextEntry(client, toolkit, MapperMessages.ColumnDetailsPage_name, 0);
        this.nameEntry.setDescription(MapperMessages.ColumnDetailsPage_the_name_of_the_column);
        this.nameEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setName(entry.getValue());
            }
        });
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        this.jdbcTypeEntry = new FormTextEntry(client, toolkit, MapperMessages.ColumnDetailsPage_jdbc_type, 0);
        this.jdbcTypeEntry.setDescription(MapperMessages.ColumnDetailsPage_which_jdbc_type_this_column_should_have);
        this.jdbcTypeEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setJDBCType(entry.getValue());
            }
        });
        this.propertyEntry = new FormTextEntry(client, toolkit, MapperMessages.ColumnDetailsPage_property_name, 0);
        this.propertyEntry.setDescription(MapperMessages.ColumnDetailsPage_the_property_name_which_must_be_used_for);
        this.propertyEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setPropertyName(entry.getValue());
            }
        });
        this.typeEntry = new FormTextEntry(client, toolkit, MapperMessages.ColumnDetailsPage_hibernate_type, 0);
        this.typeEntry.setDescription(MapperMessages.ColumnDetailsPage_the_hibernate_type);
        this.typeEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setType(entry.getValue());
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IRevEngColumn newColumn = (IRevEngColumn)((IStructuredSelection)selection).getFirstElement();
        if (this.column != null) {
            this.column.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (newColumn != null) {
            newColumn.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.column = newColumn;
        this.update();
    }

    private void update() {
        this.nameEntry.setValue(this.column.getName());
        this.jdbcTypeEntry.setValue(this.column.getJDBCType());
        this.propertyEntry.setValue(this.column.getPropertyName());
        this.typeEntry.setValue(this.column.getType());
        this.nameEntry.setEditable(!this.column.getExclude());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }
}

