/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.util.XModelObjectCache;

public class TextEditorComponent
implements ITextListener,
ITextEditorExtension {
    protected XModelObjectCache object = null;
    protected IDocument document = null;
    protected IDocumentPartitioner partitioner = null;
    protected SourceViewer preview = null;
    protected boolean lock = false;
    protected IEditorPart editorPart = null;
    private boolean modified = false;
    private OverlayPreferenceStore overlay = null;
    private Map<String, IStatusField> fStatusFields = new HashMap<String, IStatusField>();
    private boolean fOverwriting = false;

    public TextEditorComponent() {
        this.init();
    }

    protected void init() {
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public Control createControl(Composite container) {
        return this.createPreviewer(container);
    }

    public Control getControl() {
        return this.preview.getControl();
    }

    public void setObject(XModelObject object) {
        this.object = new XModelObjectCache(object);
        this.update();
    }

    public XModelObject getModelObject() {
        return this.object == null ? null : this.object.getObject();
    }

    public void setModified(boolean set) {
        this.modified = set;
    }

    public boolean isModified() {
        return this.modified;
    }

    protected String loadContent() {
        XModelObject o = this.getModelObject();
        String content = o == null ? "" : o.get("body");
        content = content == null ? "" : content;
        return content;
    }

    public void update() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        String content = this.loadContent();
        if (this.document != null && content.equals(this.getText())) {
            this.lock = false;
            return;
        }
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
        this.document = new Document(content);
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        partitioner.connect(this.document);
        this.document.setDocumentPartitioner(partitioner);
        this.preview.setDocument(this.document);
        this.setModified(false);
        this.lock = false;
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        return null;
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return null;
    }

    private Control createPreviewer(Composite parent) {
        this.preview = new SourceViewer(parent, null, 2816);
        this.preview.configure(this.createSourceViewerConfiguration());
        this.preview.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.initializeViewerColors((ISourceViewer)this.preview);
        this.update();
        this.preview.addTextListener((ITextListener)this);
        this.preview.getControl().addMouseListener((MouseListener)new M());
        this.preview.getControl().addKeyListener((KeyListener)new K());
        this.createNavigationActions();
        return this.preview.getControl();
    }

    private void initializeViewerColors(ISourceViewer viewer) {
        if (this.overlay != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = null;
            if (!this.overlay.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
                color = this.createColor((IPreferenceStore)this.overlay, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            }
            styledText.setBackground(color);
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return rgb != null ? new Color((Device)display, rgb) : null;
    }

    public String getText() {
        String text = null;
        if (this.document != null) {
            text = this.document.get();
        }
        return text == null ? "" : text;
    }

    public void textChanged(TextEvent event) {
        this.modified = true;
    }

    public void save() {
        if (this.lock || !this.modified) {
            return;
        }
        this.lock = true;
        try {
            try {
                FileAnyImpl f = (FileAnyImpl)this.getModelObject();
                if (f != null) {
                    f.edit(this.getText());
                }
            }
            catch (XModelException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
                this.lock = false;
                this.modified = false;
            }
        }
        finally {
            this.lock = false;
            this.modified = false;
        }
    }

    public void setCursor(int line, int position) {
        try {
            int i = this.document.getLineOffset(line - 1) + position - 1;
            this.preview.setSelectedRange(i, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void createNavigationActions() {
        ToggleInsertModeAction action = new ToggleInsertModeAction(this.preview.getTextWidget());
        action.setActionDefinitionId("org.eclipse.ui.edit.text.toggleOverwrite");
        this.setAction("org.eclipse.ui.edit.text.toggleOverwrite", (IAction)action);
    }

    public void setAction(String actionID, IAction action) {
        if (this.editorPart == null) {
            return;
        }
        this.editorPart.getSite().getKeyBindingService().registerAction(action);
    }

    protected IStatusField getStatusField(String category) {
        if (category != null && this.fStatusFields != null) {
            return this.fStatusFields.get(category);
        }
        return null;
    }

    public void setStatusField(IStatusField field, String category) {
        if (field == null) {
            this.fStatusFields.remove(category);
        } else {
            this.fStatusFields.put(category, field);
            this.updateStatusField(category);
        }
    }

    public boolean isEditorInputReadOnly() {
        XModelObject o = this.getModelObject();
        return o != null && !o.isObjectEditable();
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
    }

    protected void handleCursorPositionChanged() {
        this.updateStatusField("InputPosition");
        this.updateStatusField("ElementState");
    }

    protected void updateStatusField(String category) {
        if (category == null) {
            return;
        }
        IStatusField field = this.getStatusField(category);
        if (field != null) {
            String text = null;
            if ("InputPosition".equals(category)) {
                text = this.getCursorPosition();
            } else if ("ElementState".equals(category)) {
                text = this.isEditorInputReadOnly() ? "Read Only" : "Writable";
            } else if ("InputMode".equals(category)) {
                text = !this.fOverwriting ? "Insert" : "Overwrite";
            }
            field.setText(text == null ? "" : text);
        }
    }

    protected String getCursorPosition() {
        if (this.preview == null) {
            return "";
        }
        StyledText styledText = this.preview.getTextWidget();
        int caret = styledText.getCaretOffset();
        IDocument document = this.preview.getDocument();
        if (document == null) {
            return "";
        }
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i < caret) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - column % tabWidth) : ++column;
                ++i;
            }
            return ++line + " : " + ++column;
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected void handleInsertModeChanged() {
        this.updateStatusField("InputMode");
    }

    class K
    extends KeyAdapter {
        K() {
        }

        public void keyPressed(KeyEvent e) {
            TextEditorComponent.this.handleCursorPositionChanged();
        }
    }

    class M
    extends MouseAdapter {
        M() {
        }

        public void mouseUp(MouseEvent e) {
            TextEditorComponent.this.handleCursorPositionChanged();
        }
    }

    class ToggleInsertModeAction
    extends TextNavigationAction {
        public ToggleInsertModeAction(StyledText textWidget) {
            super(textWidget, 0x1000009);
        }

        public void run() {
            super.run();
            TextEditorComponent.this.fOverwriting = !TextEditorComponent.this.fOverwriting;
            TextEditorComponent.this.handleInsertModeChanged();
        }
    }
}

