/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.Properties;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class HiddenSystemsHandler
extends AbstractHandler {
    public boolean isEnabled(XModelObject object) {
        return object != null && object.isObjectEditable();
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String hidden;
        Properties fsp;
        if (!this.isEnabled(object)) {
            return;
        }
        SpecialWizard wizard = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.ui.wizards.query.list.HiddenFileSystemsWizard");
        XModelObject[] fs = object.getChildren();
        String[][] vs = new String[fs.length][];
        int i = 0;
        while (i < vs.length) {
            String name = fs[i].getAttributeValue("name");
            fsp = XModelObjectUtil.toProperties(fs[i]);
            hidden = fsp.getProperty("hidden", "no");
            String jar = "" + "FileSystemJar".equals(fs[i].getModelEntity().getName());
            vs[i] = new String[]{name, hidden, jar};
            ++i;
        }
        if (p == null) {
            p = new Properties();
        }
        p.put("data", vs);
        p.setProperty("help", "FileSystems_ShowHide");
        wizard.setObject(p);
        if (wizard.execute() != 0) {
            return;
        }
        boolean ch = false;
        int i2 = 0;
        while (i2 < vs.length) {
            fsp = XModelObjectUtil.toProperties(fs[i2]);
            hidden = fsp.getProperty("hidden", "no");
            if (!hidden.equals(vs[i2][1])) {
                fsp.setProperty("hidden", vs[i2][1]);
                fs[i2].setAttributeValue("info", XModelObjectUtil.toString(fsp));
                fs[i2].setModified(true);
                ch = true;
            }
            ++i2;
        }
        if (ch) {
            XModelImpl m = (XModelImpl)object.getModel();
            m.fireStructureChanged(object);
        }
    }
}

