/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.util.ElService;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VpeNodeInvocationHandler
implements InvocationHandler {
    private Node node;
    private VpePageContext pageContext;

    public VpeNodeInvocationHandler(VpePageContext pageContext, Node node) {
        this.node = node;
        this.pageContext = pageContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.node, args);
        if (result instanceof String) {
            String processedStr = (String)result;
            result = this.replaceEL(processedStr);
        } else if (result instanceof Attr) {
            result = VpeProxyUtil.createProxyForELExpressionNode(this.pageContext, (Node)result);
        } else if (result instanceof NamedNodeMap) {
            result = VpeProxyUtil.createProxyForNamedNodeMap(this.pageContext, (NamedNodeMap)result);
        }
        return result;
    }

    private String replaceEL(String toReplace) {
        return ElService.getInstance().replaceElAndResources(this.pageContext, toReplace);
    }
}

