/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.util.ElService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SourceDomUtil {
    private static final Set<String> templatesNamespacesWithRendered = new HashSet<String>();

    static {
        templatesNamespacesWithRendered.add("h:");
        templatesNamespacesWithRendered.add("a4j:");
        templatesNamespacesWithRendered.add("rich:");
        templatesNamespacesWithRendered.add("seam:");
    }

    public static Node getAncestorNode(Node sourceNode, String tagName) {
        if (tagName == null) {
            return null;
        }
        Node element = sourceNode;
        do {
            if (!tagName.equalsIgnoreCase(element.getNodeName())) continue;
            return element;
        } while ((element = element.getParentNode()) != null);
        return null;
    }

    public static Node getParentHavingDomMapping(Node sourceNode, VpeDomMapping domMapping) {
        VpeNodeMapping nodeMapping = null;
        Node parent = sourceNode;
        while ((nodeMapping = domMapping.getNodeMapping(parent = parent.getParentNode())) == null && parent != null) {
        }
        return parent;
    }

    public static boolean isRenderedAttrEqFalse(VpePageContext pageContext, Element sourceNode) {
        boolean result = false;
        Element tempElement = sourceNode;
        if (sourceNode.hasAttribute("rendered")) {
            String templateName;
            String[] templatePrefix;
            if (ElService.getInstance().isELNode(pageContext, sourceNode)) {
                tempElement = (Element)VpeProxyUtil.createProxyForELExpressionNode(pageContext, sourceNode);
            }
            if ("false".equals(tempElement.getAttribute("rendered")) && (templatePrefix = (templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, sourceNode)).split(":")).length > 1 && templatesNamespacesWithRendered.contains(String.valueOf(templatePrefix[0]) + ":")) {
                result = true;
            }
        }
        return result;
    }

    public static Element getFacetByName(VpePageContext pageContext, Element sourceElement, String facetName) {
        if (facetName == null) {
            return null;
        }
        Element facetElement = null;
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (SourceDomUtil.isFacetElement(pageContext, node) && facetName.equalsIgnoreCase(((Element)node).getAttribute("name"))) {
                facetElement = (Element)node;
            }
            ++i;
        }
        return facetElement;
    }

    public static boolean isFacetElement(VpePageContext pageContext, Node node) {
        if (node instanceof Element) {
            String templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, node);
            return "f:facet".equals(templateName);
        }
        return false;
    }

    public static String getXPath(Node node) {
        return XSLTXPathHelper.calculateXPathToNode((Node)node);
    }

    public static Node getNodeByXPath(Document document, String xPath) {
        Node currentNode = document;
        try {
            String[] nodeNames = xPath.split("/");
            int i = 1;
            while (i < nodeNames.length) {
                String nodeName = nodeNames[i];
                if (nodeName.charAt(0) != '@') {
                    currentNode = currentNode.getFirstChild();
                    if (nodeName.charAt(nodeName.length() - 1) != ']') {
                        while (currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals(nodeName)) {
                            currentNode = currentNode.getNextSibling();
                        }
                    } else {
                        int openingBracketIndex = nodeName.lastIndexOf(91);
                        String stringPosition = nodeName.substring(openingBracketIndex + 1, nodeName.length() - 1);
                        nodeName = nodeName.substring(0, openingBracketIndex);
                        int position = Integer.parseInt(stringPosition);
                        int curPosition = 0;
                        while (currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals(nodeName) || ++curPosition != position) {
                            currentNode = currentNode.getNextSibling();
                        }
                    }
                } else {
                    String attributeName = nodeName.substring(1, nodeName.length());
                    currentNode = currentNode.getAttributes().getNamedItem(attributeName);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return currentNode;
    }
}

