/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportConfigurationTab
extends Composite {
    private final FindbugsPropertyPage propertyPage;
    private List<Button> chkEnableBugCategoryList;
    private Combo minPriorityCombo;

    public ReportConfigurationTab(TabFolder parent, FindbugsPropertyPage page, int style) {
        super((Composite)parent, style);
        this.propertyPage = page;
        this.setLayout((Layout)new GridLayout());
        TabItem tabDetector = new TabItem(parent, 0);
        tabDetector.setText(this.getMessage("property.reportConfigurationTab"));
        tabDetector.setControl((Control)this);
        tabDetector.setToolTipText("Configure bugs reported to the UI");
        this.createPriorityGroup(this);
        this.createBugCategoriesGroup(this, page.getProject());
    }

    private void createPriorityGroup(ReportConfigurationTab parent) {
        Composite prioGroup = new Composite((Composite)parent, 0);
        prioGroup.setLayout((Layout)new GridLayout(2, false));
        Label minPrioLabel = new Label(prioGroup, 0);
        minPrioLabel.setText(this.getMessage("property.minPriority"));
        minPrioLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minPriorityCombo = new Combo(prioGroup, 12);
        this.minPriorityCombo.add("High");
        this.minPriorityCombo.add("Medium");
        this.minPriorityCombo.add("Low");
        this.minPriorityCombo.setText(this.propertyPage.getOriginalUserPreferences().getFilterSettings().getMinPriority());
        this.minPriorityCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.minPriorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String data = ReportConfigurationTab.this.minPriorityCombo.getText();
                ReportConfigurationTab.this.getCurrentProps().getFilterSettings().setMinPriority(data);
            }
        });
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    private void createBugCategoriesGroup(Composite parent, IProject project) {
        Group checkBoxGroup = new Group(parent, 64);
        checkBoxGroup.setText(this.getMessage("property.categoriesGroup"));
        checkBoxGroup.setLayout((Layout)new GridLayout(1, true));
        LinkedList<String> bugCategoryList = new LinkedList<String>(I18N.instance().getBugCategories());
        this.chkEnableBugCategoryList = new LinkedList<Button>();
        ProjectFilterSettings origFilterSettings = this.propertyPage.getOriginalUserPreferences().getFilterSettings();
        for (String category : bugCategoryList) {
            Button checkBox = new Button((Composite)checkBoxGroup, 32);
            checkBox.setText(I18N.instance().getBugCategoryDescription(category));
            checkBox.setSelection(origFilterSettings.containsCategory(category));
            GridData layoutData = new GridData();
            layoutData.horizontalIndent = 10;
            checkBox.setLayoutData((Object)layoutData);
            checkBox.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ReportConfigurationTab.this.syncSelectedCategories();
                }
            });
            checkBox.setData((Object)category);
            this.chkEnableBugCategoryList.add(checkBox);
        }
    }

    protected void syncSelectedCategories() {
        ProjectFilterSettings filterSettings = this.getCurrentProps().getFilterSettings();
        for (Button checkBox : this.chkEnableBugCategoryList) {
            String category = (String)checkBox.getData();
            if (checkBox.getSelection()) {
                filterSettings.addCategory(category);
                continue;
            }
            filterSettings.removeCategory(category);
        }
        this.propertyPage.getVisibleDetectors().clear();
        this.propertyPage.getDetectorTab().refreshTable();
    }

    protected UserPreferences getCurrentProps() {
        return this.propertyPage.getCurrentUserPreferences();
    }

    public void setEnabled(boolean enabled) {
        this.minPriorityCombo.setEnabled(enabled);
        for (Button checkBox : this.chkEnableBugCategoryList) {
            checkBox.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    void refreshUI(UserPreferences prefs) {
        ProjectFilterSettings filterSettings = prefs.getFilterSettings();
        this.minPriorityCombo.setText(filterSettings.getMinPriority());
        for (Button checkBox : this.chkEnableBugCategoryList) {
            checkBox.setSelection(filterSettings.containsCategory((String)checkBox.getData()));
        }
        this.syncSelectedCategories();
    }

    protected List<Button> getChkEnableBugCategoryList() {
        return this.chkEnableBugCategoryList;
    }
}

