/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.editor.ErrorSelectionListener;
import org.jboss.tools.common.editor.SelectionNotifier;
import org.jboss.tools.common.editor.form.RightFormContainer;
import org.jboss.tools.common.editor.form.SampleErrorForm;
import org.jboss.tools.common.editor.form.SampleTreeForm;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.forms.DefaultFormContainer;
import org.jboss.tools.common.model.ui.forms.DefaultFormFactory;
import org.jboss.tools.common.model.ui.forms.DefaultFormPage;
import org.jboss.tools.common.model.ui.forms.FormFactory;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.forms.IFormFactory;
import org.jboss.tools.common.model.ui.forms.LayouredFormFactory;
import org.jboss.tools.common.model.ui.forms.MementoDOM;
import org.jboss.tools.common.model.ui.forms.SplitFormContainer;
import org.jboss.tools.common.model.ui.forms.XModelObjectFormFactory;
import org.jboss.tools.common.model.ui.resources.ResourceLayoutManager;
import org.jboss.tools.common.model.ui.texteditors.TextActionHelper;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;

public class TreeFormPage
extends DefaultFormPage
implements ITextEditor,
ITextOperationTarget,
ISelectionChangedListener {
    private SelectionNotifier selectionNotifier;
    private XModelObject installedObject;
    private XModel model;
    private boolean errorMode;
    private Map<String, IAction> actions = new HashMap<String, IAction>();
    private ArrayList<String> actionMapping = new ArrayList();
    private IEditorSite site;
    private IEditorInput input;
    private DefaultFormContainer mainContainer;
    private SplitFormContainer splitContainer;
    private SampleTreeForm treeForm;
    private SampleErrorForm errorForm;
    private RightFormContainer rightFormContainer;
    private XModelTreeListenerSWTASync modelListener = new XModelTreeListenerSWTASync(new XMTL());
    private MementoDOM memento;
    private XModelObject selection = null;

    public TreeFormPage() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        this.selectionNotifier = new SelectionNotifier();
        this.selectionNotifier.addSelectionChangedListener(this);
        this.setSelectionProvider(this.selectionNotifier);
        this.errorForm = new SampleErrorForm();
        this.errorForm.setVisible(Boolean.FALSE);
        this.errorForm.setLayout((Layout)layout);
        this.treeForm = new SampleTreeForm((IEditorPart)this);
        this.treeForm.setSelectionNotifier(this.selectionNotifier);
        this.rightFormContainer = new RightFormContainer();
        this.rightFormContainer.setSelectionChangedListener(this.selectionNotifier);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.splitContainer = new SplitFormContainer(this.treeForm, this.rightFormContainer);
        this.splitContainer.setLayout((Layout)layout);
        this.splitContainer.setLayoutData(new GridData(1808));
        this.mainContainer = new DefaultFormContainer();
        this.mainContainer.setLayoutData(new GridData(1808));
        this.mainContainer.addForm(this.errorForm);
        this.mainContainer.addForm(this.splitContainer);
        this.form = this.mainContainer;
    }

    public void addErrorSelectionListener(ErrorSelectionListener listener) {
        this.errorForm.addErrorSelectionListener(listener);
    }

    public void addFilter(XFilteredTreeConstraint filter) {
        this.treeForm.addFilter(filter);
    }

    public void initialize(Object model) {
        this.installedObject = (XModelObject)model;
        this.model = this.installedObject.getModel();
        this.treeForm.initialize(model);
    }

    public Control createFormControl(Composite parent, IWidgetSettings settings) {
        final XModel m = this.model;
        m.addModelTreeListener((XModelTreeListener)this.modelListener);
        Control c = super.createFormControl(parent, settings);
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                m.removeModelTreeListener((XModelTreeListener)TreeFormPage.this.modelListener);
            }
        });
        return c;
    }

    public void update() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        if (this.treeForm != null) {
            this.treeForm.update();
        }
        if (this.rightFormContainer != null) {
            this.rightFormContainer.update();
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionNotifier;
    }

    private void printActionList(String level, XActionList actionList) {
        if (!ModelUIPlugin.getDefault().isDebugging()) {
            return;
        }
        actionList.getName();
        actionList.getDisplayName();
        actionList.getPath();
        XActionItem[] items = actionList.getActionItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof XActionList) {
                this.printActionList(String.valueOf(level) + "    ", (XActionList)items[i]);
            } else {
                items[i].getName();
                items[i].getDisplayName();
                items[i].getPath();
            }
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IForm form;
        XModelObject xmo = this.getModelObject(event.getSelection());
        if (this.selection == xmo) {
            return;
        }
        this.selection = xmo;
        if (xmo != null && xmo.getModelEntity() != null) {
            this.printActionList("", xmo.getModelEntity().getActionList());
        }
        IForm iForm = form = xmo == null ? null : this.getFormFactory(xmo).getForm();
        if (this.rightFormContainer.size() > 0 && this.memento != null) {
            Iterator i = this.rightFormContainer.iterator();
            while (i.hasNext()) {
                IForm iForm2 = (IForm)i.next();
                IMemento formMemento = this.memento.getChild(iForm2.getHeadingText());
                if (formMemento == null) {
                    formMemento = this.memento.createChild(iForm2.getHeadingText());
                }
                iForm2.store(formMemento);
            }
        }
        this.rightFormContainer.clear();
        if (form != null) {
            form.initialize(xmo);
            if (this.memento != null) {
                IMemento formMementro = this.memento.getChild(form.getHeadingText());
                if (formMementro == null) {
                    formMementro = this.memento.createChild(form.getHeadingText());
                }
                form.load(formMementro);
            }
            this.rightFormContainer.addForm(form);
            form.setParent(this.rightFormContainer);
            if (this.checkFocus()) {
                this.setFocus();
            }
        }
    }

    boolean checkFocus() {
        Control c = Display.getDefault().getFocusControl();
        return c == null;
    }

    private IFormFactory getFormFactory(XModelObject selected) {
        if (selected == null) {
            return null;
        }
        XModelObjectFormFactory formFactory = null;
        String formFactoryClassName = selected.getModelEntity().getProperty("formFactory");
        if (formFactoryClassName != null) {
            if ("%Default%".equals(formFactoryClassName)) {
                return new LayouredFormFactory(selected);
            }
            Class cls = ModelFeatureFactory.getInstance().getFeatureClass(formFactoryClassName);
            if (cls == null) {
                return new FormFactory(selected);
            }
            try {
                Constructor c = cls.getConstructor(XModelObject.class);
                formFactory = (XModelObjectFormFactory)c.newInstance(selected);
            }
            catch (InstantiationException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (SecurityException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            return formFactory == null ? new FormFactory(selected) : formFactory;
        }
        formFactory = new DefaultFormFactory(selected);
        return formFactory;
    }

    private XModelObject getModelObject(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        Object o = s.getFirstElement();
        return o instanceof XModelObject ? (XModelObject)o : null;
    }

    public boolean isErrorMode() {
        return this.errorMode;
    }

    public void setErrorMode(boolean b) {
        this.errorMode = b;
        if (this.installedObject != null) {
            this.doErrorMode();
        }
        this.mainContainer.setEnabled(!b);
    }

    private void doErrorMode() {
        if (this.isErrorMode()) {
            this.errorForm.initialize(this.getErrors());
            this.errorForm.setVisible(Boolean.TRUE);
        } else {
            this.errorForm.setVisible(Boolean.FALSE);
        }
    }

    private String getErrors() {
        XModelObject f = this.installedObject;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (f == null) {
            f = this.installedObject;
        }
        return f.get("errors");
    }

    public IDocumentProvider getDocumentProvider() {
        return null;
    }

    public void close(boolean save) {
        this.store();
    }

    public boolean isEditable() {
        return false;
    }

    public void doRevertToSaved() {
    }

    public void setAction(String actionID, IAction action) {
        this.actions.put(actionID, action);
    }

    public IAction getAction(String id) {
        return this.actions.get(id);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
    }

    public void removeActionActivationCode(String actionId) {
    }

    public boolean showsHighlightRangeOnly() {
        return false;
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
    }

    public IRegion getHighlightRange() {
        return null;
    }

    public void resetHighlightRange() {
    }

    public void selectAndReveal(int offset, int length) {
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public IEditorSite getEditorSite() {
        return this.site;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.site = site;
        this.input = input;
        if (input instanceof IFileEditorInput) {
            this.memento = new MementoDOM(ResourceLayoutManager.getDefault().getLayoutElement((IResource)this.getFile(), "TreeFormPage"));
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        super.createControl(parent);
        this.createActions();
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void setFocus() {
        if (this.treeForm != null && this.treeForm.getControl() != null && !this.treeForm.getControl().isDisposed()) {
            this.treeForm.setFocus();
        } else if (this.control != null && !this.control.isDisposed()) {
            this.control.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (ITextOperationTarget.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    private IFile getFile() {
        return this.input instanceof IFileEditorInput ? ((IFileEditorInput)this.input).getFile() : null;
    }

    private void store() {
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        ResourceLayoutManager.getDefault().store((IResource)file);
    }

    public void doSave(IProgressMonitor monitor) {
        this.store();
    }

    public void doSaveAs() {
        this.store();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean canDoOperation(int operation) {
        return true;
    }

    public void doOperation(int operation) {
        if (operation > this.actionMapping.size()) {
            ModelUIPlugin.getPluginLog().logError((Throwable)new IllegalArgumentException("Can not find global action with index: " + operation));
        } else {
            String globalAction = this.actionMapping.get(operation);
            this.doGlobalAction(globalAction);
        }
    }

    protected void createActions() {
        this.actionMapping.add(null);
        this.actionMapping.add(1, ActionFactory.UNDO.getId());
        this.actionMapping.add(2, ActionFactory.REDO.getId());
        this.actionMapping.add(3, ActionFactory.CUT.getId());
        this.actionMapping.add(4, ActionFactory.COPY.getId());
        this.actionMapping.add(5, ActionFactory.PASTE.getId());
        this.actionMapping.add(6, ActionFactory.DELETE.getId());
        this.actionMapping.add(7, ActionFactory.SELECT_ALL.getId());
        this.actionMapping.add(8, "ShiftRight");
        this.actionMapping.add(9, "ShiftLeft");
        this.actionMapping.add(10, ActionFactory.PRINT.getId());
        TextActionHelper.addCutAction(this);
        TextActionHelper.addCopyAction(this);
        TextActionHelper.addPasteAction(this);
        TextActionHelper.addDeleteAction(this);
    }

    public void doGlobalAction(String action) {
        if (this.errorForm != null && this.errorForm.isVisible() && this.errorForm.doGlobalAction(action)) {
            return;
        }
        if (this.treeForm.doGlobalAction(action)) {
            return;
        }
        this.mainContainer.doGlobalAction(action);
    }

    class XMTL
    implements XModelTreeListener {
        XMTL() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            XModelObject o = event.getModelObject();
            String p1 = TreeFormPage.this.installedObject.getPath() + "/";
            String p2 = o.getPath() + "/";
            if (p2.startsWith(p1)) {
                TreeFormPage.this.update();
            }
        }

        public void structureChanged(XModelTreeEvent event) {
            XModelObject o = event.getModelObject();
            String p1 = TreeFormPage.this.installedObject.getPath() + "/";
            String p2 = o.getPath() + "/";
            if (p2.startsWith(p1)) {
                TreeFormPage.this.update();
            }
        }
    }
}

