/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.ProgressListener;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.workbench.BasicWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.ProgressListenerMonitor;
import org.hibernate.eclipse.console.workbench.TableContainer;

public class LazyDatabaseSchemaWorkbenchAdapter
extends BasicWorkbenchAdapter {
    public Object[] getChildren(Object o) {
        return this.getChildren(o, (IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized Object[] getChildren(Object o, IProgressMonitor monitor) {
        LazyDatabaseSchema dbs = this.getLazyDatabaseSchema(o);
        ConsoleConfiguration consoleConfiguration = dbs.getConsoleConfiguration();
        try {
            DefaultDatabaseCollector db = this.readDatabaseSchema(monitor, consoleConfiguration, dbs.getReverseEngineeringStrategy());
            ArrayList<TableContainer> result = new ArrayList<TableContainer>();
            Iterator qualifierEntries = db.getQualifierEntries();
            while (qualifierEntries.hasNext()) {
                Map.Entry entry = (Map.Entry)qualifierEntries.next();
                result.add(new TableContainer((String)entry.getKey(), (List)entry.getValue()));
            }
            return this.toArray(result.iterator(), TableContainer.class, new Comparator<TableContainer>(){

                @Override
                public int compare(TableContainer arg0, TableContainer arg1) {
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
        }
        catch (HibernateException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.LazyDatabaseSchemaWorkbenchAdapter_problems_while_reading_database_schema, e);
            String out = NLS.bind((String)HibernateConsoleMessages.LazyDatabaseSchemaWorkbenchAdapter_reading_schema_error, (Object)e.getMessage());
            return new Object[]{out};
        }
    }

    private LazyDatabaseSchema getLazyDatabaseSchema(Object o) {
        return (LazyDatabaseSchema)o;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return EclipseImages.getImageDescriptor("TABLE");
    }

    public String getLabel(Object o) {
        return HibernateConsoleMessages.LazyDatabaseSchemaWorkbenchAdapter_database;
    }

    public Object getParent(Object o) {
        return this.getLazyDatabaseSchema(o).getConsoleConfiguration();
    }

    protected DefaultDatabaseCollector readDatabaseSchema(final IProgressMonitor monitor, ConsoleConfiguration consoleConfiguration, final ReverseEngineeringStrategy strategy) {
        final Configuration configuration = consoleConfiguration.buildWith(null, false);
        return (DefaultDatabaseCollector)consoleConfiguration.execute(new ExecutionContext.Command(){

            public Object execute() {
                DefaultDatabaseCollector db = null;
                Settings settings = configuration.buildSettings();
                ConnectionProvider connectionProvider = null;
                try {
                    try {
                        connectionProvider = settings.getConnectionProvider();
                        JDBCReader reader = JDBCReaderFactory.newJDBCReader((Properties)configuration.getProperties(), (Settings)settings, (ReverseEngineeringStrategy)strategy);
                        db = new DefaultDatabaseCollector(reader.getMetaDataDialect());
                        reader.readDatabaseSchema((DatabaseCollector)db, settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (ProgressListener)new ProgressListenerMonitor(monitor));
                    }
                    catch (HibernateException he) {
                        throw he;
                    }
                    catch (UnsupportedOperationException he) {
                        throw new HibernateException((Throwable)he);
                    }
                }
                finally {
                    if (connectionProvider != null) {
                        connectionProvider.close();
                    }
                }
                return db;
            }
        });
    }
}

