/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.preferences.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

class PreferencesManagerImpl
implements IPreferencesManager {
    private static final Logger log;
    private static final String PROJECT_BUILD_PATH_ENABLED = "net.sourceforge.pmd.eclipse.plugin.project_build_path_enabled";
    private static final String PMD_PERSPECTIVE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_perspective_enabled";
    private static final String MAX_VIOLATIONS_PFPR = "net.sourceforge.pmd.eclipse.plugin.max_violations_pfpr";
    private static final String REVIEW_ADDITIONAL_COMMENT = "net.sourceforge.pmd.eclipse.plugin.review_additional_comment";
    private static final String REVIEW_PMD_STYLE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.review_pmd_style_enabled";
    private static final String MIN_TILE_SIZE = "net.sourceforge.pmd.eclipse.plugin.min_tile_size";
    private static final String LOG_FILENAME = "net.sourceforge.pmd.eclipse.plugin.log_filename";
    private static final String LOG_LEVEL = "net.sourceforge.pmd.eclipse.plugin.log_level";
    private static final String OLD_PREFERENCE_PREFIX = "net.sourceforge.pmd.runtime";
    private static final String OLD_PREFERENCE_LOCATION = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.runtime.prefs";
    private static final String NEW_PREFERENCE_LOCATION = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.eclipse.plugin.prefs";
    private static final String PREFERENCE_RULESET_FILE = "/ruleset.xml";
    private IPreferences preferences;
    private IPreferenceStore storePreferencesStore = PMDPlugin.getDefault().getPreferenceStore();
    private IPreferenceStore loadPreferencesStore;
    private RuleSet ruleSet;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    PreferencesManagerImpl() {
    }

    public IPreferences loadPreferences() {
        if (this.preferences == null) {
            this.initLoadPreferencesStore();
            PreferencesFactoryImpl preferencesFactoryImpl = new PreferencesFactoryImpl();
            this.preferences = preferencesFactoryImpl.newPreferences(this);
            this.loadProjectBuildPathEnabled();
            this.loadPmdPerspectiveEnabled();
            this.loadMaxViolationsPerFilePerRule();
            this.loadReviewAdditionalComment();
            this.loadReviewPmdStyleEnabled();
            this.loadMinTileSize();
            this.loadLogFileName();
            this.loadLogLevel();
        }
        return this.preferences;
    }

    private void initLoadPreferencesStore() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = iWorkspaceRoot.getLocation();
        File file = new File(iPath.append(NEW_PREFERENCE_LOCATION).toString());
        File file2 = new File(iPath.append(OLD_PREFERENCE_LOCATION).toString());
        this.loadPreferencesStore = this.storePreferencesStore;
        if (!file.exists() && file2.exists()) {
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
                fileInputStream.close();
                this.loadPreferencesStore = new PreferenceStore();
                Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    String string = (String)entry.getKey();
                    if (string.startsWith(OLD_PREFERENCE_PREFIX)) {
                        string = string.replaceFirst(OLD_PREFERENCE_PREFIX, "net.sourceforge.pmd.eclipse.plugin");
                    }
                    this.loadPreferencesStore.putValue(string, (String)entry.getValue());
                }
            }
            catch (IOException iOException) {
                PMDPlugin.getDefault().logError("IOException in loading old format preferences", iOException);
                this.loadPreferencesStore = this.storePreferencesStore;
            }
        }
    }

    public void storePreferences(IPreferences iPreferences) {
        this.preferences = iPreferences;
        this.storeProjectBuildPathEnabled();
        this.storePmdPerspectiveEnabled();
        this.storeMaxViolationsPerFilePerRule();
        this.storeReviewAdditionalComment();
        this.storeReviewPmdStyleEnabled();
        this.storeMinTileSize();
        this.storeLogFileName();
        this.storeLogLevel();
    }

    public RuleSet getRuleSet() {
        if (this.ruleSet == null) {
            this.ruleSet = this.getRuleSetFromStateLocation();
        }
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.updateConfiguredProjects(ruleSet);
        this.ruleSet = ruleSet;
        this.storeRuleSetInStateLocation(this.ruleSet);
    }

    private void loadProjectBuildPathEnabled() {
        this.loadPreferencesStore.setDefault(PROJECT_BUILD_PATH_ENABLED, true);
        this.preferences.setProjectBuildPathEnabled(this.loadPreferencesStore.getBoolean(PROJECT_BUILD_PATH_ENABLED));
    }

    private void loadPmdPerspectiveEnabled() {
        this.loadPreferencesStore.setDefault(PMD_PERSPECTIVE_ENABLED, true);
        this.preferences.setPmdPerspectiveEnabled(this.loadPreferencesStore.getBoolean(PMD_PERSPECTIVE_ENABLED));
    }

    private void loadMaxViolationsPerFilePerRule() {
        this.loadPreferencesStore.setDefault(MAX_VIOLATIONS_PFPR, 5);
        this.preferences.setMaxViolationsPerFilePerRule(this.loadPreferencesStore.getInt(MAX_VIOLATIONS_PFPR));
    }

    private void loadReviewAdditionalComment() {
        this.loadPreferencesStore.setDefault(REVIEW_ADDITIONAL_COMMENT, "by {0} on {1}");
        this.preferences.setReviewAdditionalComment(this.loadPreferencesStore.getString(REVIEW_ADDITIONAL_COMMENT));
    }

    private void loadReviewPmdStyleEnabled() {
        this.loadPreferencesStore.setDefault(REVIEW_PMD_STYLE_ENABLED, true);
        this.preferences.setReviewPmdStyleEnabled(this.loadPreferencesStore.getBoolean(REVIEW_PMD_STYLE_ENABLED));
    }

    private void loadMinTileSize() {
        this.loadPreferencesStore.setDefault(MIN_TILE_SIZE, 25);
        this.preferences.setMinTileSize(this.loadPreferencesStore.getInt(MIN_TILE_SIZE));
    }

    private void loadLogFileName() {
        this.loadPreferencesStore.setDefault(LOG_FILENAME, "pmd-eclipse.log");
        this.preferences.setLogFileName(this.loadPreferencesStore.getString(LOG_FILENAME));
    }

    private void loadLogLevel() {
        this.loadPreferencesStore.setDefault(LOG_LEVEL, IPreferences.LOG_LEVEL.toString());
        this.preferences.setLogLevel(Level.toLevel((String)this.loadPreferencesStore.getString(LOG_LEVEL)));
    }

    private void storeProjectBuildPathEnabled() {
        this.storePreferencesStore.setValue(PROJECT_BUILD_PATH_ENABLED, this.preferences.isProjectBuildPathEnabled());
    }

    private void storePmdPerspectiveEnabled() {
        this.storePreferencesStore.setValue(PMD_PERSPECTIVE_ENABLED, this.preferences.isPmdPerspectiveEnabled());
    }

    private void storeMaxViolationsPerFilePerRule() {
        this.storePreferencesStore.setValue(MAX_VIOLATIONS_PFPR, this.preferences.getMaxViolationsPerFilePerRule());
    }

    private void storeReviewAdditionalComment() {
        this.storePreferencesStore.setValue(REVIEW_ADDITIONAL_COMMENT, this.preferences.getReviewAdditionalComment());
    }

    private void storeReviewPmdStyleEnabled() {
        this.storePreferencesStore.setValue(REVIEW_PMD_STYLE_ENABLED, this.preferences.isReviewPmdStyleEnabled());
    }

    private void storeMinTileSize() {
        this.storePreferencesStore.setValue(MIN_TILE_SIZE, this.preferences.getMinTileSize());
    }

    private void storeLogFileName() {
        this.storePreferencesStore.setValue(LOG_FILENAME, this.preferences.getLogFileName());
    }

    private void storeLogLevel() {
        this.storePreferencesStore.setValue(LOG_LEVEL, this.preferences.getLogLevel().toString());
    }

    private RuleSet getRuleSetFromStateLocation() {
        Object object;
        RuleSet ruleSet = null;
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        IPath iPath = PMDPlugin.getDefault().getStateLocation().append(PREFERENCE_RULESET_FILE);
        File file = new File(iPath.toOSString());
        if (file.exists()) {
            try {
                object = new FileInputStream(iPath.toOSString());
                ruleSet = ruleSetFactory.createRuleSet((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                PMDPlugin.getDefault().logError("File Not Found Exception when loading state ruleset file", fileNotFoundException);
            }
            catch (IOException iOException) {
                PMDPlugin.getDefault().logError("IO Exception when loading state ruleset file", iOException);
            }
            catch (RuntimeException runtimeException) {
                PMDPlugin.getDefault().logError("Runtime Exception when loading state ruleset file", runtimeException);
            }
        }
        if (ruleSet == null) {
            ruleSet = new RuleSet();
            ruleSet.setName("pmd-eclipse");
            ruleSet.setDescription("PMD Plugin preferences rule set");
            object = PMDPlugin.getDefault().getRuleSetManager();
            Iterator iterator = object.getDefaultRuleSets().iterator();
            while (iterator.hasNext()) {
                RuleSet ruleSet2 = (RuleSet)iterator.next();
                ruleSet.addRuleSetByReference(ruleSet2, false);
            }
        }
        return ruleSet;
    }

    private Set getNewRules(RuleSet ruleSet) {
        HashSet<Rule> hashSet = new HashSet<Rule>();
        Collection collection = ruleSet.getRules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (this.ruleSet.getRuleByName(rule.getName()) != null) continue;
            hashSet.add(rule);
        }
        return hashSet;
    }

    private void updateConfiguredProjects(RuleSet ruleSet) {
        Rule rule;
        log.debug((Object)"Updating configured projects");
        RuleSet ruleSet2 = new RuleSet();
        Set set = this.getNewRules(ruleSet);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            rule = (Rule)iterator.next();
            ruleSet2.addRule(rule);
        }
        rule = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < ((Rule)rule).length) {
            if (rule[n].isAccessible()) {
                try {
                    IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties((IProject)rule[n]);
                    RuleSet ruleSet3 = iProjectProperties.getProjectRuleSet();
                    if (ruleSet3 != null) {
                        ruleSet3.addRuleSet(ruleSet2);
                        ruleSet3.setExcludePatterns(new ArrayList(ruleSet.getExcludePatterns()));
                        ruleSet3.setIncludePatterns(new ArrayList(ruleSet.getIncludePatterns()));
                        iProjectProperties.setProjectRuleSet(ruleSet3);
                        iProjectProperties.sync();
                    }
                }
                catch (PropertiesException propertiesException) {
                    PMDPlugin.getDefault().logError("Unable to add new rules for project: " + rule[n], propertiesException);
                }
            }
            ++n;
        }
    }

    private void storeRuleSetInStateLocation(RuleSet ruleSet) {
        try {
            IPath iPath = PMDPlugin.getDefault().getStateLocation().append(PREFERENCE_RULESET_FILE);
            FileOutputStream fileOutputStream = new FileOutputStream(iPath.toOSString());
            IRuleSetWriter iRuleSetWriter = PMDPlugin.getDefault().getRuleSetWriter();
            iRuleSetWriter.write(fileOutputStream, ruleSet);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            PMDPlugin.getDefault().logError("IO Exception when storing ruleset in state location", iOException);
        }
        catch (WriterException writerException) {
            PMDPlugin.getDefault().logError("General PMD Eclipse Exception when storing ruleset in state location", writerException);
        }
    }
}

