/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;

public class ExtensionChange {
    private XModelObject file = null;
    private String extension = null;

    public boolean execute(XModelObject file, String extension) {
        this.file = file;
        this.extension = extension;
        return this.execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean execute() {
        XModel model = this.file.getModel();
        String entity = model.getEntityRecognizer().getEntityName(new EntityRecognizerContext(this.extension));
        String oldEntity = this.file.getModelEntity().getName();
        String body = this.__body();
        if (body == null) {
            return false;
        }
        if ("FileAny".equals(entity)) {
            if ("FileAnyLong".equals(oldEntity)) {
                return false;
            }
            if (!FileUtil.isText((String)body)) return false;
            entity = "FileTXT";
        } else if (entity == null) {
            entity = model.getEntityRecognizer().getEntityName(new EntityRecognizerContext(this.extension, body));
        }
        if (entity == null || model.getMetaData().getEntity(entity) == null) {
            entity = "FileAny";
        }
        if (this.file.getModelEntity().getName().equals(entity)) {
            return false;
        }
        XModelObject o = this.createFileObject(entity, body);
        if (o == null) {
            return false;
        }
        if (o.getModelEntity().getAttribute("_file") != null && this.file.getModelEntity().getAttribute("_file") != null) {
            o.set("_file", this.file.get("_file"));
        }
        XUndoManager undo = model.getUndoManager();
        String d = "Change extension " + this.file.getParent().getAttributeValue("name");
        XTransactionUndo u = new XTransactionUndo(d, 0);
        undo.addUndoable(u);
        try {
            try {
                XModelObject p = this.file.getParent();
                DefaultRemoveHandler.removeFromParent(this.file);
                DefaultCreateHandler.addCreatedObject(p, o, FindObjectHelper.IN_NAVIGATOR_ONLY);
                return true;
            }
            catch (XModelException xModelException) {
                undo.rollbackTransactionInProgress();
                u.commit();
                return false;
            }
        }
        finally {
            u.commit();
        }
    }

    private String __body() {
        XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(this.file);
        if (loader != null) {
            this.file.setModified(true);
            loader.save(this.file);
            return XModelObjectLoaderUtil.getTempBody(this.file);
        }
        if (this.file.getModelEntity().getAttribute("_file") != null) {
            String sfn = this.file.get("_file");
            if (sfn.length() == 0) {
                return null;
            }
            File sf = new File(sfn);
            return sf.isFile() ? FileUtil.readFile((File)sf) : null;
        }
        return this.file.getAttributeValue("body");
    }

    private XModelObject createFileObject(String entity, String body) {
        Properties p = new Properties();
        p.setProperty("name", this.file.getAttributeValue("name"));
        p.setProperty("extension", this.extension);
        XModelObject c = this.file.getModel().createModelObject(entity, p);
        XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(c);
        if (loader != null) {
            XModelObjectLoaderUtil.setTempBody(c, body);
            loader.load(c);
        } else {
            c.setAttributeValue("body", body);
        }
        return c;
    }
}

