/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.IMarkerSelectionHandler;
import de.tobject.findbugs.view.UserAnnotationsView;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractFindbugsView
extends ViewPart
implements IMarkerSelectionHandler {
    static final String DETAILS_VIEW_IMG = "detailsView.png";
    static final String USER_ANNOTATIONS_VIEW_IMG = "annotationsView.png";
    static final String TREE_VIEW_IMG = "treeView.png";
    static final String PERSPECTIVE_IMG = "buggy-tiny.png";
    private Composite root;
    private Action actionShowDetailsView;
    private Action actionShowBugTreeView;
    private Action actionShowAnnotationsView;
    private Action actionShowPerspective;

    protected final void activate() {
        if (!this.isVisible()) {
            this.getSite().getPage().activate((IWorkbenchPart)this);
        }
    }

    public final boolean isVisible() {
        return this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void setFocus() {
        this.getRootControl().setFocus();
    }

    public void dispose() {
        this.getRootControl().dispose();
        super.dispose();
    }

    public final void createPartControl(Composite parent) {
        this.root = this.createRootControl(parent);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public final Composite getRootControl() {
        return this.root;
    }

    protected abstract Composite createRootControl(Composite var1);

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractFindbugsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.getRootControl());
        this.getRootControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void makeActions() {
        this.actionShowAnnotationsView = new Action(){

            public void run() {
                AbstractFindbugsView.showUserAnnotationView();
            }
        };
        this.configureAction(this.actionShowAnnotationsView, "Show Bug Annotations View", "Show Annotations View", USER_ANNOTATIONS_VIEW_IMG);
        this.actionShowBugTreeView = new Action(){

            public void run() {
                AbstractFindbugsView.showBugTreeView();
            }
        };
        this.configureAction(this.actionShowBugTreeView, "Show Bug Tree View", "Show BugTree View", TREE_VIEW_IMG);
        this.actionShowDetailsView = new Action(){

            public void run() {
                AbstractFindbugsView.showDetailsView();
            }
        };
        this.configureAction(this.actionShowDetailsView, "Show Bug Details View", "Show Bug Details View", DETAILS_VIEW_IMG);
        this.actionShowPerspective = new Action(){

            public void run() {
                AbstractFindbugsView.this.showPerspective();
            }
        };
        this.configureAction(this.actionShowPerspective, "Switch to FindBugs Perspective", "Switch to FindBugs Perspective", PERSPECTIVE_IMG);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowPerspective);
        manager.add((IContributionItem)new Separator());
        if (!(this instanceof UserAnnotationsView)) {
            manager.add((IAction)this.actionShowAnnotationsView);
        }
        manager.add((IAction)this.actionShowBugTreeView);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowPerspective);
        manager.add((IContributionItem)new Separator());
        if (!(this instanceof UserAnnotationsView)) {
            manager.add((IAction)this.actionShowAnnotationsView);
        }
        manager.add((IAction)this.actionShowBugTreeView);
    }

    protected void hookDoubleClickAction() {
    }

    protected final void configureAction(Action action, String textKey, String tooltipKey, String imageKey) {
        action.setText(FindbugsPlugin.getResourceString(textKey));
        action.setToolTipText(FindbugsPlugin.getResourceString(tooltipKey));
        action.setImageDescriptor(FindbugsPlugin.getDefault().getImageDescriptor(imageKey));
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        return service;
    }

    static IViewPart showUserAnnotationView() {
        IWorkbenchPage page = FindbugsPlugin.getActiveWorkbenchWindow().getActivePage();
        try {
            return page.showView("de.tobject.findbugs.view.userannotationsview");
        }
        catch (PartInitException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not show bug annotations view");
            return null;
        }
    }

    static IViewPart showDetailsView() {
        IWorkbenchPage page = FindbugsPlugin.getActiveWorkbenchWindow().getActivePage();
        try {
            return page.showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not show bug details view");
            return null;
        }
    }

    static IViewPart showBugTreeView() {
        IWorkbenchPage page = FindbugsPlugin.getActiveWorkbenchWindow().getActivePage();
        try {
            return page.showView("de.tobject.findbugs.view.bugtreeview");
        }
        catch (PartInitException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not show bug tree view");
            return null;
        }
    }

    final void showPerspective() {
        IWorkbenchPage page = this.getSite().getPage();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        Object input = page != null ? page.getInput() : ResourcesPlugin.getWorkspace().getRoot();
        try {
            PlatformUI.getWorkbench().showPerspective("de.tobject.findbugs.FindBugsPerspective", window, input);
        }
        catch (WorkbenchException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to open FindBugs Perspective");
        }
    }
}

