/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;

public class PathUtils {
    public static IPath getGlobalLocation(IArchiveNode node) {
        if (node instanceof IArchive) {
            IArchive a = (IArchive)node;
            return PathUtils.getGlobalLocation(a.getRawDestinationPath(), a.getProjectName(), a.isDestinationInWorkspace(), a.getDescriptorVersion());
        }
        if (node instanceof IArchiveStandardFileSet) {
            IArchiveStandardFileSet a = (IArchiveStandardFileSet)node;
            return PathUtils.getGlobalLocation(a.getRawSourcePath(), a.getProjectName(), a.isInWorkspace(), a.getDescriptorVersion());
        }
        return null;
    }

    public static String getAbsoluteLocation(IArchiveNode node) {
        if (node instanceof IArchive) {
            IArchive a = (IArchive)node;
            return PathUtils.getAbsoluteLocation(a.getRawDestinationPath(), a.getProjectName(), a.isDestinationInWorkspace(), a.getDescriptorVersion());
        }
        if (node instanceof IArchiveStandardFileSet) {
            IArchiveStandardFileSet a = (IArchiveStandardFileSet)node;
            return PathUtils.getAbsoluteLocation(a.getRawSourcePath(), a.getProjectName(), a.isInWorkspace(), a.getDescriptorVersion());
        }
        return null;
    }

    public static IPath getGlobalLocation(String expression, String projectName, boolean inWorkspace, double version) {
        String absolute = PathUtils.getAbsoluteLocation(expression, projectName, inWorkspace, version);
        if (absolute != null) {
            if (inWorkspace) {
                IPath p = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath((IPath)new Path(absolute));
                return p;
            }
            return new Path(absolute);
        }
        return null;
    }

    public static String getAbsoluteLocation(String expression, String projectName, boolean inWorkspace, double version) {
        if (inWorkspace && ("".equals(expression) || ".".equals(expression))) {
            return new Path(projectName).makeAbsolute().toString();
        }
        try {
            String translated = ArchivesCore.getInstance().getVFS().performStringSubstitution(expression, projectName, true);
            if (inWorkspace) {
                if (version >= 1.2) {
                    Path p = new Path(translated);
                    if (!p.isAbsolute()) {
                        p = new Path(projectName).append((IPath)p).makeAbsolute();
                    }
                    return p.toString();
                }
                return new Path(translated).makeAbsolute().toString();
            }
            if (new Path(translated).isAbsolute()) {
                return new Path(translated).toString();
            }
            IPath projectPath = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath((IPath)new Path(projectName));
            return projectPath.append(translated).toString();
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

