/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.NonJavaResource;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.core.resources.XModelObjectEditorInputFactory;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.ModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.Paths;
import org.jboss.tools.common.util.FileUtil;

public class ModelObjectStorageEditorInput
extends ModelObjectEditorInput
implements IStorageEditorInput {
    IJarEntryResource jarEntryFile = null;
    IStorage storage = new Storage();

    public ModelObjectStorageEditorInput(XModelObject object) {
        super(object);
        this.jarEntryFile = this.findJarEntryFile();
    }

    public IStorage getStorage() throws CoreException {
        return this.jarEntryFile != null ? this.jarEntryFile : this.storage;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    IJarEntryResource findJarEntryFile() {
        XModelObject o = this.object;
        JarEntryFile f = null;
        JarEntryFile current = null;
        String packageName = "";
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<XModelObject> os = new ArrayList<XModelObject>();
        while (o != null && o.getFileType() != 3) {
            String part;
            String string = o.getFileType() == 1 ? FileAnyImpl.toFileName((XProperty)o) : (part = o.getFileType() == 2 ? o.getAttributeValue("name") : null);
            if (part != null) {
                parts.add(0, part);
                os.add(0, o);
                if (f == null) {
                    current = f = new JarEntryFile(part){

                        public InputStream getContents() throws CoreException {
                            return ModelObjectStorageEditorInput.this.storage.getContents();
                        }
                    };
                } else {
                    packageName = packageName.length() > 0 ? String.valueOf(part) + "." + packageName : part;
                    JarEntryDirectory d = new JarEntryDirectory(part);
                    current.setParent((Object)d);
                    current = d;
                }
            }
            o = o.getParent();
        }
        String file = Paths.expand((String)o.get("location"), (Properties)o.getModel().getProperties());
        IProject p = EclipseResourceUtil.getProject((XModelObject)o);
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)p);
        if (jp == null) {
            return null;
        }
        IPackageFragmentRoot root = null;
        try {
            IPackageFragmentRoot[] rs;
            IPackageFragmentRoot[] iPackageFragmentRootArray = rs = jp.getAllPackageFragmentRoots();
            int n = rs.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot r = iPackageFragmentRootArray[n2];
                if (r.getResource() != null && r.getResource().exists() && r.getResource().getLocation().toString().equals(file)) {
                    root = r;
                } else if (r.getPath() != null && r.getPath().toString().equals(file)) {
                    root = r;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getDefault().logError(e);
        }
        if (root == null) {
            root = jp.getPackageFragmentRoot(file);
        }
        if (root == null) {
            return null;
        }
        if (current != null && !"META-INF".equalsIgnoreCase(current.getName()) && packageName.length() > 0) {
            IPackageFragment pf = root.getPackageFragment(packageName);
            f.setParent((Object)pf);
        } else {
            current.setParent((Object)root);
            if (!(o instanceof JarSystemImpl)) {
                IPackageFragmentRoot q = root;
                NonJavaResource nj = null;
                int i = 0;
                while (i < parts.size()) {
                    IResource ri = (IResource)((XModelObject)os.get(i)).getAdapter(IResource.class);
                    if (ri == null) {
                        return f;
                    }
                    nj = new NonJavaResource((Object)q, ri);
                    q = nj;
                    ++i;
                }
                if (nj != null) {
                    return nj;
                }
            }
        }
        return f;
    }

    protected boolean isEditable() {
        return false;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof IStorageEditorInput) {
            String[] entryInfo;
            try {
                IStorage st = ((IStorageEditorInput)o).getStorage();
                if (this.jarEntryFile != null && this.jarEntryFile.equals(st)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            if ((entryInfo = XModelObjectEditorInput.parseJarEntryFileInput((IStorageEditorInput)o)) == null) {
                return false;
            }
            XModelObject mo = XModelObjectEditorInput.getJarEntryObject(null, entryInfo[0], entryInfo[1]);
            return mo != null && mo.equals(this.object);
        }
        return false;
    }

    class Storage
    implements IStorage {
        Storage() {
        }

        public InputStream getContents() throws CoreException {
            ByteArrayInputStream b = null;
            if (ModelObjectStorageEditorInput.this.object instanceof FileAnyImpl) {
                FileAnyImpl f = (FileAnyImpl)ModelObjectStorageEditorInput.this.object;
                String s = f.getAsText();
                String encoding = FileUtil.getEncoding((String)s);
                byte[] bs = null;
                if (encoding == null) {
                    bs = s.getBytes();
                } else {
                    try {
                        bs = s.getBytes(encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bs = s.getBytes();
                    }
                }
                b = new ByteArrayInputStream(bs);
            } else {
                b = new ByteArrayInputStream(new byte[0]);
            }
            return b;
        }

        public IPath getFullPath() {
            IProject p = EclipseResourceUtil.getProject((XModelObject)ModelObjectStorageEditorInput.this.object);
            if (p == null) {
                String location = XModelObjectEditorInputFactory.getFileLocation(ModelObjectStorageEditorInput.this.object);
                if (location != null) {
                    return new Path(location);
                }
            } else {
                IResource jar;
                XModelObject f = ModelObjectStorageEditorInput.this.object;
                while (f != null && f.getFileType() != 3) {
                    f = f.getParent();
                }
                if (f != null && (jar = EclipseResourceUtil.getResource((XModelObject)f)) != null) {
                    return jar.getFullPath();
                }
            }
            String n = p == null ? "" : p.getName();
            return new Path(String.valueOf(n) + "/" + ModelObjectStorageEditorInput.this.object.getPath());
        }

        public String getName() {
            return ModelObjectStorageEditorInput.this.getName();
        }

        public boolean isReadOnly() {
            return !ModelObjectStorageEditorInput.this.isEditable();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ILocationProvider.class && ModelObjectStorageEditorInput.this instanceof ILocationProvider) {
                return (ILocationProvider)ModelObjectStorageEditorInput.this;
            }
            return ModelObjectStorageEditorInput.this.getAdapter(adapter);
        }
    }
}

