/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.navigator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.project.ModelNature;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.ui.views.navigator.FilteredTreesCache;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;

public class NavigatorContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected FilteredTreesCache filteredTrees = FilteredTreesCache.getInstance();
    protected TreeViewer viewer = null;
    protected TreeViewerModelListenerImpl listener;
    protected XModelTreeListenerSWTASync syncListener;
    protected Set<String> projects = new HashSet<String>();
    protected int isLoading = 0;

    public void dispose() {
        IWorkspace workspace;
        if (this.viewer != null && (workspace = this.getWorkspace(this.viewer.getInput())) != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.projects != null) {
            this.projects.clear();
            this.projects = null;
        }
        if (this.filteredTrees != null && this.syncListener != null) {
            this.filteredTrees.removeListener(this.syncListener);
        }
        this.syncListener = null;
    }

    public void setListener(TreeViewerModelListenerImpl listener) {
        this.listener = listener;
        this.syncListener = new XModelTreeListenerSWTASync(listener);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof XModelObject) {
            XFilteredTree tree = this.getFilteredTree(parentElement);
            return tree == null ? null : this.getFilteredTree(parentElement).getChildren((XModelObject)parentElement);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof XModelObject) {
            XFilteredTree tree = this.getFilteredTree(element);
            return tree == null ? null : tree.getParent((XModelObject)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof XModelObject) {
            XModelObject o = (XModelObject)element;
            if (!o.isActive()) {
                return false;
            }
            XFilteredTree tree = this.getFilteredTree(element);
            return tree != null && tree.hasChildren((XModelObject)element);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        ++this.isLoading;
        try {
            IProject p;
            XModelObject root;
            this.projects.clear();
            TreeMap<Object, XModelObject> result = new TreeMap<Object, XModelObject>(new C());
            if (inputElement instanceof IWorkspaceRoot) {
                IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)inputElement;
                IProject[] projects = workspaceRoot.getProjects();
                int i = 0;
                while (i < projects.length) {
                    XModelObject root2 = this.addProject(projects[i]);
                    if (root2 != null) {
                        result.put(projects[i].getName(), root2);
                    }
                    ++i;
                }
            } else if (inputElement instanceof IProject && (root = this.addProject(p = (IProject)inputElement)) != null) {
                result.put(p.getName(), root);
            }
            Object[] objectArray = result.values().toArray();
            return objectArray;
        }
        finally {
            --this.isLoading;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IWorkspace newWorkspace;
        this.viewer = (TreeViewer)viewer;
        IWorkspace oldWorkspace = this.getWorkspace(oldInput);
        if (oldWorkspace != (newWorkspace = this.getWorkspace(newInput))) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    private IWorkspace getWorkspace(Object input) {
        return input instanceof IWorkspace ? (IWorkspace)input : (input instanceof IContainer ? ((IContainer)input).getWorkspace() : null);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (this.isLoading > 0) {
            return;
        }
        final IResourceDelta delta = event.getDelta();
        final IResource resource = event.getResource();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    switch (event.getType()) {
                        case 1: {
                            NavigatorContentProvider.this.handlePostChange(delta);
                            break;
                        }
                        case 2: {
                            NavigatorContentProvider.this.handlePreClose(resource);
                            break;
                        }
                        case 4: {
                            NavigatorContentProvider.this.handlePreDelete(resource);
                        }
                    }
                    NavigatorContentProvider.this.check();
                }
            });
        }
    }

    private XModelObject addProject(IProject project) {
        XFilteredTree tree;
        if (project == null || !project.isOpen()) {
            return null;
        }
        IModelNature nature = this.getModelNature(project);
        if (nature == null) {
            return null;
        }
        XModelObject root = nature.getModel().getRoot();
        if (!project.isOpen()) {
            root = root.copy(0);
        }
        if ((tree = this.getFilteredTree(root)) == null) {
            return null;
        }
        if (this.listener != null) {
            this.listener.setViewer(this.viewer);
            this.filteredTrees.addListener(this.syncListener, nature.getModel());
        }
        this.projects.add(project.getLocation().toString());
        return tree.getRoot();
    }

    protected IModelNature getModelNature(IProject project) {
        return EclipseResourceUtil.getModelNature((IProject)project);
    }

    protected String getFilteredTreeName(XModel model) {
        return this.getFilteredTreeName();
    }

    protected String getFilteredTreeName() {
        return "FileSystems";
    }

    XFilteredTree getFilteredTree(Object object) {
        if (object instanceof XModelObject) {
            XModel model = ((XModelObject)object).getModel();
            if (FileSystemsHelper.getFileSystems((XModel)model) == null) {
                return null;
            }
            String name = this.getFilteredTreeName(model);
            return this.filteredTrees.getFilteredTree(name, model);
        }
        return null;
    }

    private void handlePostChange(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(5);
        if (affectedChildren.length > 0) {
            ArrayList<XModelObject> affected = new ArrayList<XModelObject>();
            int i = 0;
            while (i < affectedChildren.length) {
                XModelObject root;
                IProject project = (IProject)affectedChildren[i].getResource().getAdapter(IProject.class);
                if ((affectedChildren[i].getKind() == 1 || affectedChildren[i].getKind() == 4 && (affectedChildren[i].getFlags() & 0x4000) != 0 || !this.projects.contains(project.getLocation().toString())) && ModelNature.checkModelNature((IProject)project) && (root = this.addProject(project)) != null) {
                    affected.add(root);
                }
                ++i;
            }
            if (!affected.isEmpty()) {
                this.viewer.add(this.viewer.getInput(), affected.toArray());
                this.viewer.refresh();
            }
        }
    }

    private void handlePreClose(IResource resource) {
        this.handlePreDelete(resource);
    }

    private void handlePreDelete(IResource resource) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IProject project = (IProject)resource.getAdapter(IProject.class);
        if (project == null) {
            return;
        }
        XModelObject root = this.getRootByProject(project);
        this.projects.remove(project.getLocation().toString());
        if (root != null) {
            root.getModel().removeModelTreeListener((XModelTreeListener)this.syncListener);
            this.filteredTrees.remove(root.getModel());
            this.viewer.remove((Object)root);
        }
    }

    protected XModelObject getRootByProject(IProject project) {
        if (project == null || !project.isOpen()) {
            return null;
        }
        IModelNature nature = EclipseResourceUtil.getModelNature((IProject)project);
        if (nature == null) {
            return null;
        }
        XFilteredTree filteredTree = this.getFilteredTree(nature.getModel().getRoot());
        return filteredTree != null ? filteredTree.getRoot() : null;
    }

    private void check() {
        if (this.viewer == null) {
            return;
        }
        Tree swtTree = this.viewer.getTree();
        if (swtTree == null || swtTree.isDisposed()) {
            return;
        }
        TreeItem[] is = swtTree.getItems();
        if (is == null || is.length == 0) {
            return;
        }
        int i = 0;
        while (i < is.length) {
            XModelObject o = (XModelObject)is[i].getData();
            if (o != null) {
                IProject p = EclipseResourceUtil.getProject((XModelObject)o);
                IModelNature nature = EclipseResourceUtil.getModelNature((IProject)p);
                if (nature == null) {
                    o.getModel().removeModelTreeListener((XModelTreeListener)this.syncListener);
                    this.viewer.remove((Object)o);
                    if (p != null && p.exists() && p.getLocation() != null) {
                        this.projects.remove(p.getLocation().toString());
                    }
                } else {
                    String classname = o.getModel().getMetaData().getMapping("FilteredTrees").getValue(this.getFilteredTreeName(o.getModel()));
                    XFilteredTree tree = this.getFilteredTree(o.getModel().getRoot());
                    if (tree != null && !tree.getClass().getName().equals(classname)) {
                        o.getModel().removeModelTreeListener((XModelTreeListener)this.syncListener);
                        this.projects.remove(p.getLocation().toString());
                        this.viewer.remove((Object)o);
                        this.viewer.refresh();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class C
    implements Comparator<Object> {
        C() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return (o1 == null ? "" : o1.toString()).compareToIgnoreCase(o2 == null ? "" : o2.toString());
        }
    }
}

