/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Jsf2ResourceUtil {
    private static final Pattern resourcePatternWithSingleQuotes = Pattern.compile("[#\\$]\\{\\s*resource\\s*\\[\\s*'(.*)'\\s*\\]\\s*\\}");
    private static final Pattern resourcePatternWithDoableQuotes = Pattern.compile("[#\\$]\\{\\s*resource\\s*\\[\\s*\"(.*)\"\\s*\\]\\s*\\}");
    private static final Pattern jsfExternalContextPath = Pattern.compile("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}");
    private static final Pattern jsfRequestContextPath = Pattern.compile("^\\s*(\\#|\\$)\\{request.contextPath\\}");

    public static boolean isContainJSFContextPath(Node sourceNode) {
        boolean result = false;
        if (sourceNode.getNodeType() == 3) {
            String textValue = sourceNode.getNodeValue();
            if (textValue != null && (Jsf2ResourceUtil.isExternalContextPathString(textValue) || Jsf2ResourceUtil.isRequestContextPathString(textValue))) {
                result = true;
            }
        } else {
            NamedNodeMap nodeMap = sourceNode.getAttributes();
            if (nodeMap != null && nodeMap.getLength() > 0) {
                int i = 0;
                while (i < nodeMap.getLength()) {
                    Attr nodeAttr = (Attr)nodeMap.item(i);
                    String attrValue = nodeAttr.getValue();
                    if (Jsf2ResourceUtil.isExternalContextPathString(attrValue) || Jsf2ResourceUtil.isRequestContextPathString(attrValue)) {
                        result = true;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public static boolean isExternalContextPathString(String attributeValue) {
        Matcher externalContextPathMatcher = jsfExternalContextPath.matcher(attributeValue);
        boolean result = false;
        if (externalContextPathMatcher.find()) {
            result = true;
        }
        return result;
    }

    public static boolean isRequestContextPathString(String attributeValue) {
        Matcher requestContextPathMatcher = jsfRequestContextPath.matcher(attributeValue);
        return requestContextPathMatcher.find();
    }

    public static boolean isContainJSF2ResourceAttributes(Node sourceNode) {
        boolean result = false;
        if (sourceNode.getNodeType() == 3) {
            String textValue = sourceNode.getNodeValue();
            if (textValue != null && Jsf2ResourceUtil.isJSF2ResourceString(textValue)) {
                result = true;
            }
        } else {
            NamedNodeMap nodeMap = sourceNode.getAttributes();
            if (nodeMap != null && nodeMap.getLength() > 0) {
                int i = 0;
                while (i < nodeMap.getLength()) {
                    if (Jsf2ResourceUtil.isJSF2ResourceString(((Attr)nodeMap.item(i)).getValue())) {
                        result = true;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public static final String processCustomJSFAttributes(VpePageContext pageContext, String value) {
        String result = null;
        Matcher singleQuotesMatcher = resourcePatternWithSingleQuotes.matcher(value);
        Matcher doubleQuotesMatcher = resourcePatternWithDoableQuotes.matcher(value);
        if (doubleQuotesMatcher.find()) {
            result = FileUtil.getJSF2ResourcePath(pageContext, doubleQuotesMatcher.group(1));
        } else if (singleQuotesMatcher.find()) {
            result = FileUtil.getJSF2ResourcePath(pageContext, singleQuotesMatcher.group(1));
        }
        return result;
    }

    public static boolean isJSF2ResourceString(String attributeValue) {
        Matcher singleQuotesMatcher = resourcePatternWithSingleQuotes.matcher(attributeValue);
        Matcher doubleQuotesMatcher = resourcePatternWithDoableQuotes.matcher(attributeValue);
        return doubleQuotesMatcher.find() || singleQuotesMatcher.find();
    }

    public static String processExternalContextPath(String value) {
        return value.replaceFirst("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}", "");
    }

    public static String processRequestContextPath(String value) {
        return value.replaceFirst(jsfRequestContextPath.pattern(), "");
    }
}

