/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.LockAnalysis;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockDataflowFactory
extends AnalysisFactory<LockDataflow> {
    public LockDataflowFactory() {
        super("lock set analysis", LockDataflow.class);
    }

    @Override
    public LockDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            throw new MethodUnprofitableException(descriptor);
        }
        ValueNumberDataflow vnaDataflow = this.getValueNumberDataflow(analysisCache, descriptor);
        DepthFirstSearch dfs = this.getDepthFirstSearch(analysisCache, descriptor);
        CFG cfg = this.getCFG(analysisCache, descriptor);
        LockAnalysis analysis = new LockAnalysis(methodGen, vnaDataflow, dfs);
        LockDataflow dataflow = new LockDataflow(cfg, analysis);
        dataflow.execute();
        return dataflow;
    }
}

