/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.dialogs;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CPDCheckDialog
extends Dialog {
    private final String[] languages;
    private final String[] formats;
    private int selectedFormat;
    private String selectedLanguage;
    private boolean createReport;
    private String tileSize;
    private Group reportGroup = null;
    private Button createReportCheckbox = null;
    private Combo languageCombo = null;
    private Text minimumTileSizeText = null;
    private Combo formatCombo = null;

    public CPDCheckDialog(Shell shell, String[] stringArray, String[] stringArray2) {
        super(shell);
        this.languages = stringArray;
        this.formats = stringArray2;
    }

    public boolean close() {
        this.selectedLanguage = this.languageCombo.getText();
        return super.close();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initialize(composite2);
        return composite2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getString("dialog.cpd.title"));
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }

    public int getTileSize() {
        int n = 0;
        try {
            n = Integer.parseInt(this.tileSize);
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = PMDPlugin.getDefault().loadPreferences().getMinTileSize();
            PMDPlugin.getDefault().logInformation("Invalid minimum tile-size: Setting to default value of " + n);
        }
        return n;
    }

    public String getSelectedFormat() {
        return this.formats[this.selectedFormat];
    }

    public boolean isCreateReportSelected() {
        return this.createReport;
    }

    private void initialize(Composite composite) {
        String string;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalIndent = 40;
        gridData.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        gridData2.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalIndent = 10;
        gridData3.heightHint = -1;
        gridData3.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.verticalIndent = 5;
        gridData4.horizontalIndent = 5;
        gridData4.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(this.getString("dialog.cpd.help.label"));
        label.setLayoutData((Object)gridData4);
        Label label2 = new Label(composite, 0);
        label2.setText(this.getString("dialog.cpd.language.label"));
        label2.setLayoutData((Object)gridData2);
        this.createLanguageCombo(composite);
        Label label3 = new Label(composite, 0);
        label3.setText(this.getString("dialog.cpd.min_tilesize.label"));
        label3.setLayoutData((Object)gridData);
        this.minimumTileSizeText = new Text(composite, 2048);
        this.minimumTileSizeText.setLayoutData((Object)gridData3);
        this.minimumTileSizeText.setToolTipText(this.getString("dialog.tooltip.cpd.tilesize"));
        int n = PMDPlugin.getDefault().loadPreferences().getMinTileSize();
        this.tileSize = string = Integer.toString(n);
        this.minimumTileSizeText.setText(string);
        this.minimumTileSizeText.setTextLimit(3);
        this.minimumTileSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CPDCheckDialog.this.tileSize = CPDCheckDialog.this.minimumTileSizeText.getText();
            }
        });
        this.createReportGroup(composite);
    }

    private void createReportGroup(Composite composite) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 30;
        gridData.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 1;
        gridData2.horizontalSpan = 2;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        gridData3.heightHint = -1;
        gridData3.grabExcessHorizontalSpace = true;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalSpan = 2;
        gridData4.verticalAlignment = 2;
        gridData4.verticalIndent = 10;
        gridData4.horizontalIndent = 10;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.reportGroup = new Group(composite, 0);
        this.reportGroup.setText(this.getString("dialog.cpd.report"));
        this.reportGroup.setLayoutData((Object)gridData4);
        this.reportGroup.setLayout((Layout)gridLayout);
        this.createReportCheckbox = new Button((Composite)this.reportGroup, 32);
        this.createReportCheckbox.setText(this.getString("dialog.cpd.create_report"));
        this.createReportCheckbox.setLayoutData((Object)gridData2);
        this.createReportCheckbox.setSelection(true);
        this.createReport = true;
        this.createReportCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CPDCheckDialog.this.formatCombo.setEnabled(CPDCheckDialog.this.createReportCheckbox.getSelection());
                CPDCheckDialog.this.createReport = CPDCheckDialog.this.createReportCheckbox.getSelection();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                CPDCheckDialog.this.formatCombo.setEnabled(CPDCheckDialog.this.createReportCheckbox.getSelection());
                CPDCheckDialog.this.createReport = CPDCheckDialog.this.createReportCheckbox.getSelection();
            }
        });
        Label label = new Label((Composite)this.reportGroup, 0);
        label.setText(this.getString("dialog.cpd.format.label"));
        label.setLayoutData((Object)gridData);
        this.createFormatCombo();
    }

    private void createLanguageCombo(Composite composite) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.verticalIndent = 10;
        gridData.horizontalIndent = 10;
        gridData.horizontalAlignment = 4;
        this.languageCombo = new Combo(composite, 4);
        this.languageCombo.setLayoutData((Object)gridData);
        this.languageCombo.setItems(this.languages);
        this.languageCombo.select(0);
        this.languageCombo.setToolTipText(this.getString("dialog.tooltip.cpd.language"));
    }

    private void createFormatCombo() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 150;
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 10;
        gridData.verticalAlignment = 2;
        this.formatCombo = new Combo((Composite)this.reportGroup, 12);
        this.formatCombo.setLayoutData((Object)gridData);
        this.formatCombo.setItems(this.formats);
        this.formatCombo.setToolTipText(this.getString("dialog.tooltip.cpd.format"));
        this.formatCombo.select(0);
        this.formatCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CPDCheckDialog.this.selectedFormat = CPDCheckDialog.this.formatCombo.getSelectionIndex();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                CPDCheckDialog.this.selectedFormat = CPDCheckDialog.this.formatCombo.getSelectionIndex();
            }
        });
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

