/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import net.sourceforge.pmd.eclipse.ui.views.actions.CalculateStatisticsAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.CollapseAllAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.PriorityFilterAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ProjectFilterAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ViolationPresentationTypeAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ViolationOverviewMenuManager {
    private final ViolationOverview overview;
    private PriorityFilterAction[] priorityActions;

    public ViolationOverviewMenuManager(ViolationOverview violationOverview) {
        this.overview = violationOverview;
    }

    public void setupActions() {
        Integer[] integerArray = PMDPlugin.getDefault().getPriorityValues();
        this.priorityActions = new PriorityFilterAction[integerArray.length];
        int n = 0;
        while (n < integerArray.length) {
            this.priorityActions[n] = new PriorityFilterAction(integerArray[n], this.overview);
            boolean bl = this.overview.getPriorityFilterList().contains(integerArray[n]);
            this.priorityActions[n].setChecked(bl);
            ++n;
        }
    }

    public void createActionBars(IToolBarManager iToolBarManager) {
        CalculateStatisticsAction calculateStatisticsAction = new CalculateStatisticsAction(this.overview);
        iToolBarManager.add((IAction)calculateStatisticsAction);
        iToolBarManager.add((IContributionItem)new Separator());
        int n = 0;
        while (n < this.priorityActions.length) {
            iToolBarManager.add((IAction)this.priorityActions[n]);
            ++n;
        }
        iToolBarManager.add((IContributionItem)new Separator());
        CollapseAllAction collapseAllAction = new CollapseAllAction(this.overview);
        iToolBarManager.add((IAction)collapseAllAction);
    }

    public void createDropDownMenu(IMenuManager iMenuManager) {
        iMenuManager.removeAll();
        this.createProjectFilterMenu(iMenuManager);
        this.createShowTypeSubmenu(iMenuManager);
    }

    public void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MenuManager menuManager = new MenuManager(ViolationOverviewMenuManager.this.getString("view.menu.resource_filter"));
                ViolationOverviewMenuManager.this.createProjectFilterMenu((IMenuManager)menuManager);
                iMenuManager.add((IContributionItem)menuManager);
                menuManager = new MenuManager(ViolationOverviewMenuManager.this.getString("view.menu.priority_filter"));
                int n = 0;
                while (n < ViolationOverviewMenuManager.this.priorityActions.length) {
                    menuManager.add((IAction)ViolationOverviewMenuManager.this.priorityActions[n]);
                    ++n;
                }
                iMenuManager.add((IContributionItem)menuManager);
                menuManager = new MenuManager(ViolationOverviewMenuManager.this.getString("view.menu.show_type"));
                ViolationOverviewMenuManager.this.createShowTypeSubmenu((IMenuManager)menuManager);
                iMenuManager.add((IContributionItem)menuManager);
                iMenuManager.add((IContributionItem)new Separator("additions"));
                iMenuManager.add((IContributionItem)new Separator("additions-end"));
            }
        });
        Tree tree = this.overview.getViewer().getTree();
        tree.setMenu(menuManager.createContextMenu((Control)tree));
        this.overview.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.overview.getViewer());
    }

    private void createProjectFilterMenu(IMenuManager iMenuManager) {
        List list = this.overview.getProjectFilterList();
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        AbstractPMDRecord[] abstractPMDRecordArray = this.overview.getAllProjects();
        int n = 0;
        while (n < abstractPMDRecordArray.length) {
            ProjectRecord projectRecord = (ProjectRecord)abstractPMDRecordArray[n];
            if (projectRecord.hasMarkers()) {
                ProjectFilterAction projectFilterAction = new ProjectFilterAction(projectRecord, this.overview);
                if (!list.contains(abstractPMDRecordArray[n])) {
                    projectFilterAction.setChecked(true);
                }
                iMenuManager.add((IAction)projectFilterAction);
                arrayList.add(projectRecord);
            }
            ++n;
        }
        iMenuManager.add((IContributionItem)new Separator());
    }

    private void createShowTypeSubmenu(IMenuManager iMenuManager) {
        ViolationPresentationTypeAction violationPresentationTypeAction = new ViolationPresentationTypeAction(this.overview, 3);
        ViolationPresentationTypeAction violationPresentationTypeAction2 = new ViolationPresentationTypeAction(this.overview, 2);
        ViolationPresentationTypeAction violationPresentationTypeAction3 = new ViolationPresentationTypeAction(this.overview, 1);
        iMenuManager.add((IAction)violationPresentationTypeAction);
        iMenuManager.add((IAction)violationPresentationTypeAction2);
        iMenuManager.add((IAction)violationPresentationTypeAction3);
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

