/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.console.model.ITypeMapping;
import org.hibernate.eclipse.console.wizards.TreeToTableComposite;
import org.hibernate.eclipse.console.wizards.TypeMappingCellModifier;
import org.hibernate.eclipse.console.wizards.TypeMappingContentProvider;
import org.hibernate.eclipse.console.wizards.TypeMappingLabelProvider;
import org.hibernate.eclipse.console.workbench.DeferredContentProvider;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.xpl.AnyAdaptableLabelProvider;
import org.hibernate.eclipse.mapper.MapperMessages;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;

public abstract class TypeMappingView
extends TreeToTableComposite {
    TreeViewer viewer;
    private TableViewer tableViewer;
    private IReverseEngineeringDefinition revEngDef;

    public TypeMappingView(Composite parent, int style) {
        super(parent, style);
    }

    public void setModel(IReverseEngineeringDefinition revEngDef) {
        this.revEngDef = revEngDef;
        this.tableViewer.setInput((Object)revEngDef);
    }

    protected void initialize() {
        super.initialize();
        this.tableViewer = this.createTypeMappingViewer();
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AnyAdaptableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new DeferredContentProvider());
        this.viewer.setInput(null);
    }

    private TableViewer createTypeMappingViewer() {
        TableViewer result = new TableViewer(this.rightTable);
        result.setUseHashlookup(true);
        result.setColumnProperties(new String[]{"jdbctype", "hibernatetype", "length", "scale", "precision", "not-null"});
        CellEditor[] editors = new CellEditor[result.getColumnProperties().length];
        editors[0] = new TreeToTableComposite.NullableTextCellEditor((Composite)result.getTable());
        editors[1] = new TreeToTableComposite.NullableTextCellEditor((Composite)result.getTable());
        editors[2] = new TreeToTableComposite.IntegerCellEditor((Composite)result.getTable());
        editors[3] = new TreeToTableComposite.IntegerCellEditor((Composite)result.getTable());
        editors[4] = new TreeToTableComposite.IntegerCellEditor((Composite)result.getTable());
        editors[5] = new TreeToTableComposite.MultiStateCellEditor((Composite)result.getTable(), 3, 2);
        result.setCellEditors(editors);
        result.setCellModifier((ICellModifier)new TypeMappingCellModifier(result));
        result.setLabelProvider((IBaseLabelProvider)new TypeMappingLabelProvider());
        result.setContentProvider((IContentProvider)new TypeMappingContentProvider((Viewer)result));
        return result;
    }

    protected void doRefreshTree() {
        ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(this.getConsoleConfigurationName());
        this.viewer.setInput((Object)new LazyDatabaseSchema(configuration));
    }

    protected abstract String getConsoleConfigurationName();

    ITypeMapping[] getTypeMappingList() {
        return this.revEngDef.getTypeMappings();
    }

    private void doAdd() {
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty()) {
            StructuredSelection ss = (StructuredSelection)selection;
            for (Object sel : ss) {
                if (sel instanceof Column) {
                    Column col = (Column)sel;
                    Integer sqlTypeCode = col.getSqlTypeCode();
                    this.createTypeMapping(col, sqlTypeCode);
                    continue;
                }
                if (sel instanceof PrimaryKey) {
                    PrimaryKey pk = (PrimaryKey)sel;
                    Iterator iter = pk.columnIterator();
                    while (iter.hasNext()) {
                        Column column = (Column)iter.next();
                        this.createTypeMapping(column, column.getSqlTypeCode());
                    }
                    continue;
                }
                this.createDefaultSqlTypeMapping();
            }
        } else {
            this.createDefaultSqlTypeMapping();
        }
    }

    private void createTypeMapping(Column col, Integer sqlTypeCode) {
        if (sqlTypeCode != null) {
            ITypeMapping typeMapping = this.revEngDef.createTypeMapping();
            typeMapping.setJDBCType(JDBCToHibernateTypeHelper.getJDBCTypeName((int)sqlTypeCode));
            int length = col.getLength();
            int precision = col.getPrecision();
            int scale = col.getScale();
            boolean nullability = col.isNullable();
            typeMapping.setHibernateType(JDBCToHibernateTypeHelper.getPreferredHibernateType((int)sqlTypeCode, (int)length, (int)precision, (int)scale, (boolean)nullability, (boolean)false));
            if (JDBCToHibernateTypeHelper.typeHasLength((int)sqlTypeCode) && length != 0 && 255 != length) {
                typeMapping.setLength(new Integer(length));
            }
            if (JDBCToHibernateTypeHelper.typeHasScaleAndPrecision((int)sqlTypeCode)) {
                if (precision != 0 && 19 != precision) {
                    typeMapping.setPrecision(new Integer(precision));
                }
                if (scale != 0 && 2 != scale) {
                    typeMapping.setScale(new Integer(scale));
                }
            }
            typeMapping.setNullable(Boolean.valueOf(!nullability));
            this.revEngDef.addTypeMapping(typeMapping);
        }
    }

    private void createDefaultSqlTypeMapping() {
        ITypeMapping createTypeMapping = this.revEngDef.createTypeMapping();
        createTypeMapping.setJDBCType("VARCHAR");
        createTypeMapping.setHibernateType("string");
        this.revEngDef.addTypeMapping(createTypeMapping);
    }

    protected String[] getAddButtonLabels() {
        return new String[]{MapperMessages.TypeMappingView_add};
    }

    protected void handleAddButtonPressed(int i) {
        switch (i) {
            case 0: {
                this.doAdd();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(i) + MapperMessages.TypeMappingView_not_known_button);
            }
        }
    }

    protected void doRemove() {
        int sel = this.rightTable.getSelectionIndex();
        TableItem[] selection = this.rightTable.getSelection();
        int i = 0;
        while (i < selection.length) {
            ITypeMapping item = (ITypeMapping)selection[i].getData();
            this.revEngDef.removeTypeMapping(item);
            ++i;
        }
        this.rightTable.setSelection(Math.min(sel, this.rightTable.getItemCount() - 1));
    }

    protected void doRemoveAll() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)MapperMessages.TypeMappingView_remove_all_mappings, (String)MapperMessages.TypeMappingView_do_you_want_to_remove_all_mappings)) {
            this.revEngDef.removeAllTypeMappings();
        }
    }

    protected void doMoveDown() {
        TableItem[] selection = this.rightTable.getSelection();
        int i = 0;
        while (i < selection.length) {
            ITypeMapping item = (ITypeMapping)selection[i].getData();
            this.revEngDef.moveTypeMappingDown(item);
            ++i;
        }
    }

    protected void doMoveUp() {
        TableItem[] selection = this.rightTable.getSelection();
        int i = 0;
        while (i < selection.length) {
            ITypeMapping item = (ITypeMapping)selection[i].getData();
            this.revEngDef.moveTypeMappingUp(item);
            ++i;
        }
    }

    protected void createTableColumns(Table table) {
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setText(MapperMessages.TypeMappingView_jdbc_type);
        column.setWidth(100);
        column = new TableColumn(table, 16384, 1);
        column.setText(MapperMessages.TypeMappingView_hibernate_type);
        column.setWidth(150);
        column = new TableColumn(table, 16384, 2);
        column.setText(MapperMessages.TypeMappingView_length);
        column.setWidth(100);
        column = new TableColumn(table, 16384, 3);
        column.setText(MapperMessages.TypeMappingView_scale);
        column.setWidth(100);
        column = new TableColumn(table, 16384, 4);
        column.setText(MapperMessages.TypeMappingView_precision);
        column.setWidth(100);
        column = new TableColumn(table, 16384, 5);
        column.setText(MapperMessages.TypeMappingView_not_null);
        column.setWidth(75);
    }

    protected String getTableTitle() {
        return MapperMessages.TypeMappingView_type_mappings;
    }

    protected String getTreeTitle() {
        return MapperMessages.TypeMappingView_database_schema;
    }
}

