/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.console.AbstractQueryPage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.ext.QueryResult;

public class JavaPage
extends AbstractQueryPage {
    private String criteriaCode;
    private QueryResult queryResult;

    public JavaPage(ConsoleConfiguration cfg, String criteriaCode, QueryInputModel model) {
        super(cfg, model);
        this.criteriaCode = criteriaCode;
        this.setTabName(this.getQueryString().replace('\n', ' ').replace('\r', ' '));
    }

    @Override
    public List<Object> getList() {
        if (this.criteriaCode == null) {
            return Collections.emptyList();
        }
        if (this.list == null) {
            this.updateQueryResults();
        }
        return this.list;
    }

    private void updateQueryResults() {
        try {
            this.list = new ArrayList();
            this.queryResult = this.getConsoleConfiguration().getHibernateExtension().executeCriteriaQuery(this.criteriaCode, this.model);
            if (!this.queryResult.hasExceptions()) {
                Iterator<Object> iter = this.queryResult.list().iterator();
                this.queryTime = this.queryResult.getQueryTime();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    this.list.add(element);
                }
                this.pcs.firePropertyChange("list", null, this.list);
            } else {
                for (Throwable e : this.queryResult.getExceptions()) {
                    this.addException(e);
                }
            }
        }
        catch (HibernateException e) {
            this.addException(e);
        }
        catch (IllegalArgumentException e) {
            this.addException(e);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public List<String> getPathNames() {
        try {
            return this.queryResult == null ? Collections.emptyList() : this.queryResult.getPathNames();
        }
        catch (HibernateException e) {
            this.addException(e);
            return null;
        }
    }

    @Override
    public void setSession(Session s) {
    }

    @Override
    public String getQueryString() {
        return this.criteriaCode;
    }

    @Override
    public void setQueryString(String criteriaCode) {
        this.criteriaCode = criteriaCode;
        this.list = null;
        this.queryResult = null;
    }
}

