/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format.css;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.vpe.editor.toolbar.format.css.MultiPropertyValue;
import org.jboss.tools.vpe.editor.toolbar.format.css.SinglePropertyValue;
import org.jboss.tools.vpe.editor.toolbar.format.css.Token;

public class StyleProperty
extends Token {
    private ArrayList<Token> tokens = new ArrayList();
    private Token name;

    public StyleProperty(String dirtyValue) {
        super(dirtyValue);
        this.parse(dirtyValue);
    }

    private void parse(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ":", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(":")) {
                this.tokens.add(new Token(token));
                continue;
            }
            if (this.name == null) {
                this.name = new Token(token);
                this.tokens.add(this.name);
                continue;
            }
            this.tokens.add(new MultiPropertyValue(token));
        }
    }

    public Token getName() {
        return this.name;
    }

    public SinglePropertyValue getSinglePropertyValue(String value) {
        int i = 0;
        while (i < this.tokens.size()) {
            MultiPropertyValue multiPropertyValue;
            SinglePropertyValue singlePropertyValue;
            if (this.tokens.get(i) instanceof MultiPropertyValue && (singlePropertyValue = (multiPropertyValue = (MultiPropertyValue)this.tokens.get(i)).getSinglePropertyValue(value)) != null) {
                return singlePropertyValue;
            }
            ++i;
        }
        return null;
    }

    private MultiPropertyValue getMultiPropertyValue(String value) {
        int i = 0;
        while (i < this.tokens.size()) {
            MultiPropertyValue multiPropertyValue;
            SinglePropertyValue singlePropertyValue;
            if (this.tokens.get(i) instanceof MultiPropertyValue && (singlePropertyValue = (multiPropertyValue = (MultiPropertyValue)this.tokens.get(i)).getSinglePropertyValue(value)) != null) {
                return multiPropertyValue;
            }
            ++i;
        }
        return null;
    }

    public MultiPropertyValue getPropertyValue() {
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.tokens.get(i) instanceof MultiPropertyValue) {
                MultiPropertyValue multiPropertyValue = (MultiPropertyValue)this.tokens.get(i);
                return multiPropertyValue;
            }
            ++i;
        }
        return null;
    }

    public String getFirstSinglePropertyValue() {
        SinglePropertyValue[] singlePropertyValues;
        MultiPropertyValue multiPropertyValue = this.getPropertyValue();
        if (multiPropertyValue != null && (singlePropertyValues = multiPropertyValue.getSinglePropertyValues()).length > 0) {
            return singlePropertyValues[0].getCleanValue();
        }
        return null;
    }

    public boolean addSingleValue(String value) {
        SinglePropertyValue singlePropertyValue = this.getSinglePropertyValue(value);
        if (singlePropertyValue == null) {
            MultiPropertyValue propertyValue = this.getPropertyValue();
            if (propertyValue == null) {
                MultiPropertyValue newPropertyValue = new MultiPropertyValue(" " + value);
                this.tokens.add(newPropertyValue);
                return true;
            }
            return propertyValue.addSingleValue(value);
        }
        return false;
    }

    public boolean removeSingleValue(String value) {
        MultiPropertyValue multiPropertyValue = this.getMultiPropertyValue(value);
        if (multiPropertyValue != null) {
            boolean result = multiPropertyValue.removeSinglePropertyValue(value);
            if (!multiPropertyValue.hasPropertyValue()) {
                this.tokens.remove(multiPropertyValue);
            }
            return result;
        }
        return false;
    }

    public boolean hasPropertyValue() {
        return this.getPropertyValue() != null;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.tokens.size()) {
            buffer.append(this.tokens.get(i).toString());
            ++i;
        }
        return buffer.toString();
    }
}

