/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.java.handlers;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public class OpenJavaSourceHandler
extends AbstractHandler {
    @Override
    public boolean isEnabled(XModelObject object) {
        if (object == null) {
            return false;
        }
        String type = this.getType(object);
        return type != null && type.length() != 0;
    }

    protected String getType(XModelObject object) {
        String attr = this.getAttribute();
        if (attr == null) {
            return null;
        }
        return object.getAttributeValue(attr);
    }

    protected String getAttribute() {
        return this.action.getProperty("attribute");
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String v;
        String n;
        if (!this.isEnabled(object)) {
            return;
        }
        String type = this.getType(object);
        type = String.valueOf(type.replace('.', '/')) + ".java";
        if ((p == null || p.getProperty("property") == null) && (n = this.action.getProperty("property")) != null && (v = object.getAttributeValue(n)) != null) {
            if (p == null) {
                p = new Properties();
            }
            p.put("property", v);
        }
        try {
            OpenJavaSourceHandler.open(object.getModel(), type, p);
        }
        catch (CoreException e) {
            throw new XModelException(e);
        }
    }

    public static void open(XModel model, String type, Properties p) throws XModelException, CoreException {
        IProject project = (IProject)model.getProperties().get("project");
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IJavaElement javaElement = javaProject.findElement((IPath)new Path(type));
        if (javaElement == null) {
            String message = "Cannot find java source.";
            if (p != null && "true".equals(p.getProperty("ignoreWarning"))) {
                p.setProperty("error", message);
            } else {
                ServiceDialog d = model.getService();
                d.showDialog(ModelMessages.WARNING, message, new String[]{"Close"}, null, 2);
            }
        } else {
            IJavaElement child;
            if (p != null && "true".equals(p.getProperty("onlySelectIfOpen"))) {
                IEditorInput ii = EditorUtility.getEditorInput((Object)javaElement);
                IWorkbenchPage page = OpenJavaSourceHandler.getWorkbenchPage();
                if (page == null) {
                    return;
                }
                IEditorPart editor = page.findEditor(ii);
                if (editor == null) {
                    return;
                }
                page.bringToTop((IWorkbenchPart)editor);
            }
            if ((child = OpenJavaSourceHandler.getElement(javaElement, p)) != null) {
                JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)javaElement), (IJavaElement)child);
            } else {
                JavaUI.openInEditor((IJavaElement)javaElement);
            }
        }
    }

    private static IJavaElement getElement(IJavaElement javaElement, Properties p) {
        if (p == null || !(javaElement instanceof IParent)) {
            return null;
        }
        String childName = p.getProperty("property");
        if (childName == null) {
            return null;
        }
        IJavaElement[] cs = null;
        try {
            cs = ((IParent)javaElement).getChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (cs != null) {
            int i = 0;
            while (i < cs.length) {
                if (cs[i] instanceof IType) {
                    String getter;
                    IMethod m;
                    IType t = (IType)cs[i];
                    if (childName.length() > 0 && (m = t.getMethod(getter = "get" + childName.substring(0, 1).toUpperCase() + childName.substring(1), new String[0])) != null && m.exists()) {
                        return m;
                    }
                    IField f = t.getField(childName);
                    if (f != null && f.exists()) {
                        return f;
                    }
                } else if (childName.equals(cs[i].getElementName())) {
                    return cs[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static IWorkbenchPage getWorkbenchPage() {
        ModelPlugin plugin = ModelPlugin.getDefault();
        IWorkbench workbench = plugin == null ? null : plugin.getWorkbench();
        IWorkbenchWindow window = workbench == null ? null : workbench.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }
}

