/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.MavenPluginFacet;
import org.jboss.forge.maven.facets.exceptions.PluginNotFoundException;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginAdapter;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyRepositoryImpl;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;

@Dependent
@Alias(value="forge.maven.MavenPluginFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenPluginFacetImpl
extends BaseFacet
implements MavenPluginFacet,
Facet {
    private static final String DEFAULT_GROUPID = "org.apache.maven.plugins";

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        try {
            this.project.getFacet(MavenCoreFacet.class);
            return true;
        }
        catch (FacetNotFoundException e) {
            return false;
        }
    }

    public List<MavenPlugin> listConfiguredPlugins() {
        List pomPlugins;
        MavenCoreFacet mavenCoreFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Build build = mavenCoreFacet.getPOM().getBuild();
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>();
        if (build != null && (pomPlugins = build.getPlugins()) != null) {
            for (Plugin plugin : pomPlugins) {
                MavenPluginAdapter adapter = new MavenPluginAdapter(plugin);
                MavenPluginBuilder pluginBuilder = MavenPluginBuilder.create().setDependency((Dependency)DependencyBuilder.create().setGroupId(plugin.getGroupId()).setArtifactId(plugin.getArtifactId()).setVersion(plugin.getVersion())).setConfiguration(adapter.getConfig());
                plugins.add((MavenPlugin)pluginBuilder);
            }
        }
        return plugins;
    }

    public void addPlugin(MavenPlugin plugin) {
        MavenCoreFacet mavenCoreFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mavenCoreFacet.getPOM();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
        }
        build.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        pom.setBuild(build);
        mavenCoreFacet.setPOM(pom);
    }

    public boolean hasPlugin(Dependency dependency) {
        try {
            this.getPlugin(dependency);
            return true;
        }
        catch (PluginNotFoundException ex) {
            return false;
        }
    }

    public MavenPlugin getPlugin(Dependency dependency) {
        String groupId = dependency.getGroupId();
        if (groupId == null || groupId.equals("")) {
            groupId = DEFAULT_GROUPID;
        }
        for (MavenPlugin mavenPlugin : this.listConfiguredPlugins()) {
            Dependency temp = mavenPlugin.getDependency();
            if (!DependencyBuilder.areEquivalent((Dependency)temp, (Dependency)DependencyBuilder.create((Dependency)dependency).setGroupId(groupId))) continue;
            return mavenPlugin;
        }
        throw new PluginNotFoundException(groupId, dependency.getArtifactId());
    }

    public void removePlugin(Dependency dependency) {
        List pomPlugins;
        MavenCoreFacet mavenCoreFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Build build = mavenCoreFacet.getPOM().getBuild();
        if (build != null && (pomPlugins = build.getPlugins()) != null) {
            for (Plugin pomPlugin : pomPlugins) {
                DependencyBuilder pluginDep = DependencyBuilder.create().setGroupId(pomPlugin.getGroupId()).setArtifactId(pomPlugin.getArtifactId());
                if (!DependencyBuilder.areEquivalent((Dependency)pluginDep, (Dependency)dependency)) continue;
                Model pom = mavenCoreFacet.getPOM();
                pom.getBuild().removePlugin(pomPlugin);
                mavenCoreFacet.setPOM(pom);
            }
        }
    }

    public void addPluginRepository(MavenPluginFacet.KnownRepository repository) {
        this.addPluginRepository(repository.name(), repository.getUrl());
    }

    public void addPluginRepository(String name, String url) {
        if (!this.hasPluginRepository(url)) {
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            Repository repo = new Repository();
            repo.setId(name);
            repo.setUrl(url);
            pom.getPluginRepositories().add(repo);
            maven.setPOM(pom);
        }
    }

    public boolean hasPluginRepository(MavenPluginFacet.KnownRepository repository) {
        return this.hasPluginRepository(repository.getUrl());
    }

    public boolean hasPluginRepository(String url) {
        MavenCoreFacet maven;
        Model pom;
        List repositories;
        if (url != null && (repositories = (pom = (maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).getPOM()).getPluginRepositories()) != null) {
            for (Repository repo : repositories) {
                if (!repo.getUrl().trim().equals(url.trim())) continue;
                repositories.remove(repo);
                maven.setPOM(pom);
                return true;
            }
        }
        return false;
    }

    public DependencyRepository removePluginRepository(String url) {
        if (url != null) {
            MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = maven.getPOM();
            List repos = pom.getPluginRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setPOM(pom);
                return new DependencyRepositoryImpl(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public List<DependencyRepository> getPluginRepositories() {
        ArrayList<DependencyRepositoryImpl> results = new ArrayList<DependencyRepositoryImpl>();
        MavenCoreFacet maven = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = maven.getPOM();
        List repos = pom.getPluginRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                results.add(new DependencyRepositoryImpl(repo.getId(), repo.getUrl()));
            }
        }
        return Collections.unmodifiableList(results);
    }
}

