/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.icons.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.icons.impl.ImageComponent;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public class XStudioIcons
implements ImageComponent {
    private static final String code = "abcdefghijklmnop";

    public String getImageString(String filename) {
        byte[] b = this.getBytes(filename);
        return b == null ? "" : this.encode(b);
    }

    public String encode(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            int h = 128 + b[i];
            sb.append(code.charAt(h / 16));
            sb.append(code.charAt(h % 16));
            ++i;
        }
        return sb.toString();
    }

    public byte[] decode(String s) {
        byte[] b = new byte[2 * s.length()];
        int i = 0;
        int k = 0;
        while (i < s.length()) {
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            b[k] = (byte)(16 * code.indexOf(c1) + code.indexOf(c2) - 128);
            i += 2;
            ++k;
        }
        return b;
    }

    private byte[] getBytes(String filename) {
        byte[] b;
        block16: {
            File f = new File(filename);
            if (!f.isFile()) {
                return new byte[0];
            }
            b = null;
            FileInputStream fr = null;
            try {
                try {
                    fr = new FileInputStream(f);
                    int length = fr.available();
                    b = new byte[length];
                    int i = 0;
                    while (i < length) {
                        i += fr.read(b, i, length - i);
                    }
                }
                catch (IOException iOException) {
                    b = new byte[]{};
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return b;
    }

    @Override
    public int getHash(XModelObject obj) {
        String s = obj.getAttributeValue("image");
        return s == null || s.trim().length() == 0 ? "defaultimage".hashCode() : s.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage(XModelObject obj) {
        String s = obj.getAttributeValue("image");
        ImageRegistry registry = ModelPlugin.getDefault().getImageRegistry();
        Image result = null;
        ImageRegistry imageRegistry = registry;
        synchronized (imageRegistry) {
            result = registry.get(s);
        }
        if (result != null && !result.isDisposed()) {
            return result;
        }
        byte[] b = this.decode(s);
        if (b != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(b);
                ImageData id = new ImageData((InputStream)is);
                Image i = new Image(null, id);
                ImageRegistry imageRegistry2 = registry;
                synchronized (imageRegistry2) {
                    registry.remove(s);
                    registry.put(s, i);
                }
                return i;
            }
            catch (SWTException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (SWTError e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return obj.getModelEntity().getMetaModel().getIconList().getImage("default.unknown");
    }
}

