/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftException;
import com.openshift.client.configuration.OpenShiftConfiguration;
import com.openshift.internal.client.AbstractOpenShiftConnectionFactory;
import com.openshift.internal.client.RestService;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClientBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;

public class OpenShiftConnectionFactory
extends AbstractOpenShiftConnectionFactory {
    public IOpenShiftConnection getConnection(String clientId, String password) throws OpenShiftException {
        OpenShiftConfiguration configuration;
        try {
            configuration = new OpenShiftConfiguration();
        }
        catch (FileNotFoundException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
        return this.getConnection(clientId, configuration.getRhlogin(), password, configuration.getLibraServer());
    }

    public IOpenShiftConnection getConnection(String clientId, String login, String password) throws OpenShiftException {
        OpenShiftConfiguration configuration;
        try {
            configuration = new OpenShiftConfiguration();
        }
        catch (FileNotFoundException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to load OpenShift configuration file.", new Object[0]);
        }
        return this.getConnection(clientId, login, password, configuration.getLibraServer());
    }

    public IOpenShiftConnection getConnection(String clientId, String login, String password, String serverUrl) throws OpenShiftException {
        try {
            IHttpClient httpClient = new UrlConnectionHttpClientBuilder().setCredentials(login, password).client();
            RestService service = new RestService(serverUrl, clientId, httpClient);
            return this.getConnection(service, login, password);
        }
        catch (FileNotFoundException e) {
            throw new OpenShiftException(e, "Failed to establish connection for user ''{0}}''", login);
        }
        catch (IOException e) {
            throw new OpenShiftException(e, "Failed to establish connection for user ''{0}}''", login);
        }
    }
}

