/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.UntargettedBinding;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.reflect.DeferredProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependencyAnalyzer
extends DefaultBindingTargetVisitor<Object, Boolean> {
    private final Set<TypeLiteral<?>> processedTypes = new HashSet();
    private final Set<Key<?>> requiredKeys = new HashSet();

    DependencyAnalyzer() {
        this.requiredKeys.add(ParameterKeys.PROPERTIES);
    }

    public Set<Key<?>> getRequiredKeys() {
        return this.requiredKeys;
    }

    public Boolean visit(UntargettedBinding<?> binding) {
        return this.analyze(binding.getKey().getTypeLiteral());
    }

    public Boolean visit(LinkedKeyBinding<?> binding) {
        return this.analyze(binding.getLinkedKey().getTypeLiteral());
    }

    public Boolean visit(ConstructorBinding<?> binding) {
        return this.collect(binding.getDependencies());
    }

    public Boolean visit(InstanceBinding<?> binding) {
        return this.collect(binding.getDependencies());
    }

    public Boolean visit(ProviderInstanceBinding<?> binding) {
        Provider provider = binding.getProviderInstance();
        if (provider instanceof DeferredProvider) {
            try {
                DeferredProvider deferredProvider = (DeferredProvider)provider;
                this.analyze(TypeLiteral.get(deferredProvider.getImplementationClass().load()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
        return this.collect(binding.getDependencies());
    }

    public Boolean visit(InjectionRequest<?> request) {
        for (InjectionPoint p : request.getInjectionPoints()) {
            this.collect(p.getDependencies());
        }
        return Boolean.TRUE;
    }

    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private Boolean analyze(TypeLiteral<?> type) {
        if ((type.getRawType().getModifiers() & 0x600) != 0) {
            return Boolean.TRUE;
        }
        try {
            if (!this.processedTypes.contains(type)) {
                this.collect(InjectionPoint.forConstructorOf(type).getDependencies());
                for (InjectionPoint p : InjectionPoint.forInstanceMethodsAndFields(type)) {
                    this.collect(p.getDependencies());
                }
                this.processedTypes.add(type);
            }
            return Boolean.TRUE;
        }
        catch (Throwable e) {
            return Boolean.FALSE;
        }
    }

    private Boolean collect(Collection<Dependency<?>> dependencies) {
        for (Dependency<?> d : dependencies) {
            this.requiredKeys.add(d.getKey());
        }
        return Boolean.TRUE;
    }
}

