/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * Interface used to associate the resource adapter with objects that implement
 * this interface.
 */
public interface ResourceAdapterAssociation
{
   /**
    * Retrieve the resource adapter
    *
    * @return the resource adapter
    */
   ResourceAdapter getResourceAdapter();

   /**
    * Set the resource adapter
    *
    * @param the resource adapter
    * @throws ResourceException for any error
    * @throws ResourceAdapterInternalException for an error in the resource adapter
    * @throws IllegalStateException if invoked more than once
    */
   void setResourceAdapter(ResourceAdapter ra) throws ResourceException;
}