/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.NameValidator;
import org.hibernate.eclipse.console.utils.LaunchHelper;

public class RenameAction
extends SelectionListenerAction {
    public static final String RENAME_ACTIONID = "actionid.rename";
    private final StructuredViewer viewer;
    private String imageFilePath = "icons/images/refresh_run.gif";

    public RenameAction(StructuredViewer viewer) {
        super(HibernateConsoleMessages.RenameAction_name);
        this.viewer = viewer;
        this.setImageDescriptor(HibernateConsolePlugin.getImageDescriptor(this.imageFilePath));
        this.setId(RENAME_ACTIONID);
    }

    public void run() {
        for (Object node : this.getSelectedNonResources()) {
            if (!(node instanceof ConsoleConfiguration)) continue;
            if (!this.renameConsoleConfiuration((ConsoleConfiguration)node)) break;
            this.viewer.refresh(node);
            break;
        }
    }

    public boolean renameConsoleConfiuration(ConsoleConfiguration config) {
        ILaunchConfiguration launchConfiguration = null;
        try {
            launchConfiguration = LaunchHelper.findHibernateLaunchConfig(config.getName());
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().showError(null, HibernateConsoleMessages.RenameAction_error_title, e);
        }
        return launchConfiguration != null ? this.renameLaunchConfiguration(launchConfiguration) : false;
    }

    public boolean renameLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        Shell mParentShell = null;
        NameValidator inputValidator = new NameValidator();
        InputDialog d = new InputDialog(mParentShell, HibernateConsoleMessages.RenameAction_dialog_title, HibernateConsoleMessages.RenameAction_dialog_message, launchConfiguration.getName(), (IInputValidator)inputValidator);
        if (d.open() == 0) {
            try {
                ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
                wc.rename(d.getValue());
                wc.doSave();
                return true;
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().showError(mParentShell, HibernateConsoleMessages.RenameAction_error_title, e);
            }
        }
        return false;
    }
}

