/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.AddConfigurationAction;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.wizards.BestGuessConsoleConfigurationVisitor;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.hibernate.eclipse.launch.ConsoleConfigurationJavaClasspathTab;
import org.hibernate.eclipse.launch.ConsoleConfigurationMainTab;
import org.hibernate.eclipse.launch.ConsoleConfigurationTabGroup;
import org.hibernate.util.xpl.StringHelper;

public class ConsoleConfigurationWizardPage
extends WizardPage
implements ILaunchConfigurationDialog {
    protected Label nameLabel;
    protected Text nameWidget;
    protected CTabFolder tabFolder;
    protected ConsoleConfigurationTabGroup tabGroup;
    protected ILaunchConfigurationWorkingCopy currentLaunchConfig;
    protected int currentTabIndex;
    protected ISelection selection;
    private boolean initializingTabs;
    private boolean firstShow = true;

    public ConsoleConfigurationWizardPage(ISelection selection) {
        super(HibernateConsoleMessages.ConsoleConfigurationWizardPage_config_page);
        this.setTitle(HibernateConsoleMessages.ConsoleConfigurationWizardPage_create_hibernate_console_config);
        this.setDescription(HibernateConsoleMessages.ConsoleConfigurationWizardPage_this_wizard_allows);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite container = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.nameLabel = new Label(container, 16640);
        this.nameLabel.setText(HibernateConsoleMessages.ConsoleConfigurationWizardPage_name);
        this.nameLabel.setLayoutData((Object)new GridData(32));
        this.nameWidget = new Text(container, 2052);
        this.nameWidget.setLayoutData((Object)new GridData(768));
        this.tabFolder = new CTabFolder(container, 0x900088);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        this.tabFolder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        this.tabFolder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        this.tabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.tabFolder.setLayoutData((Object)gd);
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.setFont(parent.getFont());
        sc.setContent((Control)container);
        this.initTabs(this.tabFolder);
        try {
            this.performStart();
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.AddConfigurationAction_problem_add_console_config, ce);
        }
        try {
            ConsoleConfigurationWizardPage.initialize(this.currentLaunchConfig, this.selection);
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.ConsoleConfigurationWizardPage_problem_while_initializing_cc, ce);
        }
        this.performInit();
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }
        };
        this.nameWidget.addModifyListener(modifyListener);
        this.setActiveTab(0);
        sc.setMinSize(this.tabFolder.computeSize(-1, -1));
        this.setControl((Control)sc);
        this.dialogChanged();
    }

    protected void initTabs(CTabFolder folder) {
        this.tabGroup = new ConsoleConfigurationTabGroup();
        this.tabGroup.createTabs(this, null);
        ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
        int i = 0;
        while (i < tabs.length) {
            tabs[i].setLaunchConfigurationDialog((ILaunchConfigurationDialog)this);
            ++i;
        }
        i = 0;
        while (i < tabs.length) {
            CTabItem item = new CTabItem(folder, 2048);
            item.setText(tabs[i].getName());
            item.setImage(tabs[i].getImage());
            tabs[i].createControl((Composite)item.getParent());
            Control control = tabs[i].getControl();
            if (control != null) {
                item.setControl(control);
            }
            ++i;
        }
    }

    public void performStart() throws CoreException {
        this.currentLaunchConfig = AddConfigurationAction.createTemporaryLaunchConfiguration().getWorkingCopy();
    }

    public void performCancel() throws CoreException {
        AddConfigurationAction.deleteTemporaryLaunchConfigurations();
    }

    public void performFinish() throws CoreException {
        this.currentLaunchConfig.rename(this.nameWidget.getText().trim());
        this.currentLaunchConfig.doSave();
        AddConfigurationAction.makeTemporaryLaunchConfigurationsPermanent();
    }

    public void performInit() {
        this.initializingTabs = true;
        this.nameWidget.setText(this.currentLaunchConfig.getName());
        this.tabGroup.initializeFrom((ILaunchConfiguration)this.currentLaunchConfig);
        this.initializingTabs = false;
    }

    protected void dialogChanged() {
        if (this.initializingTabs) {
            return;
        }
        String messageWarning = null;
        String messageError = null;
        if (this.tabGroup == null || this.currentLaunchConfig == null) {
            this.setMessage(messageWarning);
            this.updateStatus(messageError);
            return;
        }
        String name = this.getConfigurationName();
        if (name != null) {
            name = name.trim();
        }
        if ((messageError = LaunchHelper.verifyConfigurationName(name)) != null) {
            this.setMessage(messageWarning);
            this.updateStatus(messageError);
            return;
        }
        this.tabGroup.performApply(this.currentLaunchConfig);
        ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i].isValid((ILaunchConfiguration)this.currentLaunchConfig)) {
                if (messageWarning == null) {
                    messageWarning = tabs[i].getMessage();
                }
            } else if (messageError == null) {
                messageError = tabs[i].getErrorMessage();
            }
            ++i;
        }
        this.setMessage(messageWarning);
        this.updateStatus(messageError);
    }

    protected void handleTabSelected() {
        if (this.tabGroup == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
        if (this.currentTabIndex == this.tabFolder.getSelectionIndex() || tabs == null || tabs.length == 0 || this.currentTabIndex > tabs.length - 1) {
            return;
        }
        if (this.currentTabIndex != -1) {
            ILaunchConfigurationTab tab = tabs[this.currentTabIndex];
            if (this.currentLaunchConfig != null) {
                tab.deactivated(this.currentLaunchConfig);
                this.getActiveTab().activated(this.currentLaunchConfig);
            }
        }
        this.currentTabIndex = this.tabFolder.getSelectionIndex();
    }

    public void setActiveTab(int index) {
        if (this.tabGroup == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
        if (tabs != null && index >= 0 && index < tabs.length) {
            this.tabFolder.setSelection(index);
            this.handleTabSelected();
            this.dialogChanged();
        }
    }

    public ILaunchConfigurationTab getActiveTab() {
        int pageIndex;
        if (this.tabGroup == null) {
            return null;
        }
        ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
        if (this.tabFolder != null && tabs != null && (pageIndex = this.tabFolder.getSelectionIndex()) >= 0) {
            return tabs[pageIndex];
        }
        return null;
    }

    private String getConfigurationName() {
        return this.nameWidget.getText();
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String generateName(String name) {
        return null;
    }

    public String getMode() {
        return null;
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.tabGroup == null) {
            return null;
        }
        return this.tabGroup.getTabs();
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
    }

    public void setName(String name) {
        this.nameWidget.setText(name);
    }

    public void updateButtons() {
    }

    public void updateMessage() {
        this.dialogChanged();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
    }

    protected static String nonEmptyTrimOrNull(Text t) {
        return ConsoleConfigurationWizardPage.nonEmptyTrimOrNull(t.getText());
    }

    static String nonEmptyTrimOrNull(String str) {
        if (StringHelper.isEmpty((String)str)) {
            return null;
        }
        return str.trim();
    }

    protected static void setPathAttribute(ILaunchConfigurationWorkingCopy currentLaunchConfig, String attr, IPath path) {
        if (path != null) {
            currentLaunchConfig.setAttribute(attr, ConsoleConfigurationWizardPage.nonEmptyTrimOrNull(path.toOSString()));
        } else {
            currentLaunchConfig.setAttribute(attr, null);
        }
    }

    protected static void setProjAttribute(ILaunchConfigurationWorkingCopy currentLaunchConfig, String attr, IJavaProject proj) {
        if (proj != null) {
            currentLaunchConfig.setAttribute(attr, ConsoleConfigurationWizardPage.nonEmptyTrimOrNull(proj.getElementName()));
            currentLaunchConfig.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, Collections.singletonList(new Path(ConsoleConfigurationWizardPage.nonEmptyTrimOrNull(proj.getElementName())).makeAbsolute().toString()));
            currentLaunchConfig.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, Collections.singletonList(Integer.toString(4)));
        } else {
            currentLaunchConfig.setAttribute(attr, null);
            currentLaunchConfig.removeAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS);
            currentLaunchConfig.removeAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES);
        }
    }

    protected static void setStrAttribute(ILaunchConfigurationWorkingCopy currentLaunchConfig, String attr, String str) {
        if (str != null) {
            currentLaunchConfig.setAttribute(attr, ConsoleConfigurationWizardPage.nonEmptyTrimOrNull(str));
        } else {
            currentLaunchConfig.setAttribute(attr, null);
        }
    }

    public static void initialize(ILaunchConfigurationWorkingCopy launchConfig, ISelection currentSelection) throws CoreException {
        BestGuessConsoleConfigurationVisitor v = new BestGuessConsoleConfigurationVisitor();
        if (currentSelection != null && !currentSelection.isEmpty() && currentSelection instanceof IStructuredSelection) {
            IProject project;
            IStructuredSelection ssel = (IStructuredSelection)currentSelection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            IProject container = null;
            if (obj instanceof IJavaElement) {
                v.setJavaProject(((IJavaElement)obj).getJavaProject());
                if (v.getJavaProject() != null) {
                    container = v.getJavaProject().getProject();
                }
            }
            if (obj instanceof IResource) {
                IJavaProject project2;
                IResource res = (IResource)obj;
                container = obj instanceof IContainer ? (IContainer)res : res.getParent();
                if (res.getProject() != null && (project2 = JavaCore.create((IProject)res.getProject())).exists()) {
                    v.setJavaProject(project2);
                }
            }
            if (container != null && v.getJavaProject() == null) {
                project = container.getProject();
                v.setJavaProject(JavaCore.create((IProject)project));
            }
            if (container != null) {
                int i;
                container.accept((IResourceProxyVisitor)v, 0);
                if (v.getJavaProject() == null) {
                    project = container.getProject();
                    v.setJavaProject(JavaCore.create((IProject)project));
                }
                ConsoleConfigurationWizardPage.setProjAttribute(launchConfig, IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, v.getJavaProject());
                if (v.getJavaProject() != null) {
                    ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                    String uniqName = lm.generateUniqueLaunchConfigurationNameFrom(v.getJavaProject().getElementName());
                    launchConfig.rename(uniqName);
                }
                ConsoleConfigurationWizardPage.setPathAttribute(launchConfig, "org.hibernate.eclipse.launch.PROPERTY_FILE", v.getPropertyFile());
                ConsoleConfigurationWizardPage.setPathAttribute(launchConfig, "org.hibernate.eclipse.launch.CFG_XML_FILE", v.getConfigFile());
                if (v.getPersistencexml() != null) {
                    ConsoleConfigurationWizardPage.setStrAttribute(launchConfig, "org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ConsoleConfigurationPreferences.ConfigurationMode.JPA.toString());
                } else {
                    ConsoleConfigurationWizardPage.setStrAttribute(launchConfig, "org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ConsoleConfigurationPreferences.ConfigurationMode.CORE.toString());
                }
                if (!v.getMappings().isEmpty() && v.getConfigFile() == null && v.getPersistencexml() == null) {
                    IPath[] mappings = v.getMappings().toArray(new IPath[0]);
                    ArrayList<String> l = new ArrayList<String>();
                    i = 0;
                    while (i < mappings.length) {
                        IPath path = mappings[i];
                        l.add(path.toPortableString());
                        ++i;
                    }
                    launchConfig.setAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", l);
                } else {
                    launchConfig.setAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", null);
                }
                if (!v.getClasspath().isEmpty()) {
                    launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                    IPath[] custClasspath = v.getClasspath().toArray(new IPath[0]);
                    ArrayList<String> mementos = new ArrayList<String>(custClasspath.length);
                    i = 0;
                    while (i < custClasspath.length) {
                        mementos.add(custClasspath[i].toOSString());
                        ++i;
                    }
                    launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                } else {
                    launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
                    launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
                }
            } else if (obj instanceof EclipseConsoleConfiguration) {
                throw new IllegalStateException("This should never happen!");
            }
        }
    }

    public void setConfigurationFilePath(IPath configFullPath) {
        boolean flagFileWillBeCreated = false;
        try {
            IPath path = configFullPath;
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource == null) {
                flagFileWillBeCreated = true;
            }
            while (resource == null && path != null) {
                path = path.removeLastSegments(1);
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            }
            ConsoleConfigurationWizardPage.initialize(this.currentLaunchConfig, (ISelection)new StructuredSelection((Object)resource));
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.ConsoleConfigurationWizardPage_problem_while_initializing_cc, e);
        }
        if (flagFileWillBeCreated) {
            ConsoleConfigurationWizardPage.setPathAttribute(this.currentLaunchConfig, "org.hibernate.eclipse.launch.CFG_XML_FILE", configFullPath);
            ConsoleConfigurationWizardPage.setStrAttribute(this.currentLaunchConfig, "org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ConsoleConfigurationPreferences.ConfigurationMode.CORE.toString());
            ConsoleConfigurationMainTab ccmt = null;
            ConsoleConfigurationJavaClasspathTab classpathTab = null;
            ILaunchConfigurationTab[] tabs = this.tabGroup.getTabs();
            int i = 0;
            while (i < tabs.length) {
                if (tabs[i] instanceof ConsoleConfigurationMainTab) {
                    ccmt = (ConsoleConfigurationMainTab)tabs[i];
                }
                if (tabs[i] instanceof ConsoleConfigurationJavaClasspathTab) {
                    classpathTab = (ConsoleConfigurationJavaClasspathTab)tabs[i];
                }
                ++i;
            }
            if (ccmt != null) {
                ccmt.markConfigurationFileWillBeCreated();
            }
            if (classpathTab != null) {
                classpathTab.markConfigurationFileWillBeCreated();
            }
        }
        this.performInit();
        this.dialogChanged();
    }

    public void setPreviousPage(IWizardPage page) {
        if (page != null) {
            NewConfigurationWizardPage newCfgFile;
            String cpName;
            if (this.firstShow && page instanceof NewConfigurationWizardPage && (cpName = (newCfgFile = (NewConfigurationWizardPage)page).getConnectionProfileName()) != null) {
                ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.tabGroup.getTabs();
                int n = iLaunchConfigurationTabArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                    if (tab instanceof ConsoleConfigurationMainTab) {
                        ConsoleConfigurationMainTab main = (ConsoleConfigurationMainTab)tab;
                        main.selectConnectionProfile(cpName);
                    }
                    ++n2;
                }
            }
            this.firstShow = false;
        }
        super.setPreviousPage(page);
    }
}

