/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter.custom;

import java.util.ArrayList;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeListContentProvider;

public class FileSystemListContentProvider
extends DefaultXAttributeListContentProvider {
    private XModel model;
    private boolean emptyChoice = false;
    private boolean writeOnly = false;

    public void setModel(XModel model) {
        this.model = model;
    }

    @Override
    protected void loadTags() {
        XModelObject fss = this.model.getByPath("FileSystems");
        if (fss == null) {
            return;
        }
        XModelObject[] os = fss.getChildren();
        XAttributeConstraintAList c = (XAttributeConstraintAList)this.attribute.getConstraint();
        this.loadProperties(c.getValues());
        ArrayList<String> list = new ArrayList<String>(os.length + 1);
        if (this.emptyChoice) {
            list.add("");
        }
        int i = 0;
        while (i < os.length) {
            if (!this.writeOnly || os[i].isObjectEditable()) {
                list.add(os[i].get("NAME"));
            }
            ++i;
        }
        this.tags = list.toArray(new String[list.size()]);
        if (this.emptyChoice) {
            list.add("--EmptyChoice--");
        }
        if (this.writeOnly) {
            list.add("--WriteOnly--");
        }
        c.setValues(list.toArray(new String[list.size()]));
    }

    private void loadProperties(String[] props) {
        int i = 0;
        while (i < props.length) {
            if ("--EmptyChoice--".equalsIgnoreCase(props[i])) {
                this.emptyChoice = true;
            } else if ("--WriteOnly--".equalsIgnoreCase(props[i])) {
                this.writeOnly = true;
            }
            ++i;
        }
    }
}

