/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditorEx;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class DirectoryFieldEditorEx
extends StringButtonFieldEditorEx
implements IPropertyFieldEditor,
IFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected String dirChooserLabelText = null;
    protected String lastPath = null;
    protected IPropertyEditor propertyEditor;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    private Composite textChangeControl;

    public DirectoryFieldEditorEx() {
    }

    public DirectoryFieldEditorEx(IWidgetSettings settings) {
        super(settings);
    }

    protected void init() {
        this.setStringValue(this.valueProvider.getStringValue(true));
        this.setPropertyChangeListener(this);
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Control control = this.createTextChangeControl(parent);
        GridData gd = new GridData(768);
        control.setLayoutData((Object)gd);
    }

    @Override
    protected Control createTextChangeControl(Composite parent) {
        if (this.textChangeControl == null) {
            this.textChangeControl = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.textChangeControl.setLayout((Layout)gridLayout);
            Control textControl = this.createTextControl(this.textChangeControl);
            GridData gd = new GridData(768);
            textControl.setLayoutData((Object)gd);
            Label control = new Label(this.textChangeControl, 0);
            gd = new GridData();
            gd.widthHint = 5;
            control.setLayoutData((Object)gd);
            control = this.getChangeControl(this.textChangeControl);
            gd = new GridData();
            gd.widthHint = this.convertHorizontalDLUsToPixels((Control)control, 61);
            gd.heightHint = textControl.computeSize((int)-1, (int)-1).y;
            control.setLayoutData((Object)gd);
            this.init();
        }
        return this.textChangeControl;
    }

    @Override
    protected String changePressed() {
        Object v = this.callExternal(this.getShell());
        return v == null ? null : v.toString();
    }

    public Object callExternal(Shell shell) {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        if (this.dirChooserLabelText != null) {
            dialog.setMessage(this.dirChooserLabelText);
        }
        if (this.propertyEditor != null && this.propertyEditor.getValue() != null && this.propertyEditor.getValue().toString().trim().length() > 0) {
            String v = "" + this.propertyEditor.getValue();
            if (new File(v).isFile()) {
                v = new File(v).getParent();
            }
            dialog.setFilterPath(v);
        } else if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        String dir = dialog.open();
        if (dir != null) {
            if ((dir = dir.trim()).length() == 0) {
                return null;
            }
            this.lastPath = dir;
        }
        return dir;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createTextChangeControl(parent)};
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        }
        this.valueProvider.addValueChangeListener(this);
        this.init();
        this.dirChooserLabelText = propertyEditor.getLabelText();
        String v = this.valueProvider.getStringValue(false);
        if (v != null && v.length() > 0 && new File(v).isDirectory()) {
            this.lastPath = v;
        }
        this.setPropertyChangeListener(this);
        this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.valueChangeListener != null && "field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", event.getOldValue(), event.getNewValue());
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            Object v = evt.getNewValue();
            this.setStringValue(v == null ? "" : v.toString());
        }
        this.valueProvider.addValueChangeListener(this);
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    @Override
    protected void checkParent(Control control, Composite parent) {
    }

    public String getLastPath() {
        return this.lastPath;
    }

    public void setLastPath(String lastPath) {
        this.lastPath = lastPath;
    }
}

