/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.EditorMessages;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorDialog;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;

public class StringButtonFieldEditorEx
extends StringButtonFieldEditor
implements IFieldEditor,
IPropertyChangeListener,
PropertyChangeListener,
IPropertyFieldEditor {
    public static final String BUTTON_SELECTED = "Button.Selected";
    protected PropertyEditorDialog editorDialog;
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IValueChangeListener valueChangeListener;
    protected Composite composite;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public StringButtonFieldEditorEx() {
        this.setChangeButtonText(EditorMessages.getString("StringButtonFieldEditorEx_Browse"));
    }

    public StringButtonFieldEditorEx(IWidgetSettings settings) {
        super(settings);
        this.setChangeButtonText(EditorMessages.getString("StringButtonFieldEditorEx_Browse"));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(java.beans.PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
        this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
        IActionProvider actionProvider = (IActionProvider)propertyEditor.getAdapter(IActionProvider.class);
        this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
        if (actionProvider != null && this.getSettings() instanceof WhiteSettings) {
            this.setLabelAction(actionProvider.getAction("Label.Selected"));
        }
    }

    public IPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    @Override
    protected String changePressed() {
        if (this.propertyEditor != null) {
            if (this.propertyEditor.getInput() instanceof DefaultValueAdapter) {
                ((DefaultValueAdapter)this.propertyEditor.getInput()).fireEvent(BUTTON_SELECTED, "false", "true");
            }
            if (((PropertyEditor)this.propertyEditor).callsExternal()) {
                Object result = ((PropertyEditor)this.propertyEditor).callExternal(this.getShell());
                return result != null ? result.toString() : null;
            }
            this.editorDialog = new PropertyEditorDialog(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), this.propertyEditor);
            DefaultValueAdapter adapter = (DefaultValueAdapter)this.propertyEditor.getInput();
            String title = MessageFormat.format("Edit {0}", this.propertyEditor.getAttributeName());
            if (adapter != null && adapter.getAttribute() != null) {
                String key = adapter.getAttribute().getModelEntity().getName() + "." + adapter.getAttribute().getName().replace(' ', '_') + ".edit";
                String t = WizardKeys.getLabelText((String)key);
                title = t != null ? t : MessageFormat.format("Edit {0}", WizardKeys.getAttributeDisplayName((XAttribute)adapter.getAttribute(), (boolean)true));
            }
            this.editorDialog.create();
            this.editorDialog.getShell().setText(title);
            adapter.setStoreLocked(true);
            int i = this.editorDialog.open();
            if (i == 0) {
                adapter.setStoreLocked(false);
                adapter.store();
            } else {
                adapter.load();
                adapter.setStoreLocked(false);
            }
            return this.valueProvider.getStringValue(false);
        }
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, BUTTON_SELECTED, Boolean.TRUE, Boolean.FALSE);
        this.firePropertyChange(event);
        return "";
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Composite control = this.getTextChangeControl(parent);
        control.setLayoutData((Object)new GridData(768));
    }

    protected Composite getTextChangeControl(Composite parent) {
        this.createTextChangeControl(parent);
        return this.composite;
    }

    protected Control createTextChangeControl(Composite parent) {
        if (this.composite == null) {
            this.composite = new Composite(parent, 0);
        }
        this.composite.setBackgroundMode(1);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        Control textControl = this.createTextControl(this.composite);
        GridData gd = new GridData(768);
        textControl.setLayoutData((Object)gd);
        Label control = new Label(this.composite, 0);
        gd = new GridData();
        gd.widthHint = 5;
        control.setLayoutData((Object)gd);
        control = this.getChangeControl(this.composite);
        gd = new GridData();
        gd.widthHint = this.convertHorizontalDLUsToPixels((Control)control, 61);
        gd.heightHint = textControl.computeSize((int)-1, (int)-1).y;
        control.setLayoutData((Object)gd);
        if (this.valueProvider != null) {
            String value = this.valueProvider.getStringValue(Boolean.TRUE);
            this.getTextField().setText(value);
            if (this.getLabelAction() != null) {
                this.getLabelAction().setEnabled(value != null);
            }
        }
        return this.composite;
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        if (this.isSelectableLabel() && this.getLabelControl() != null && !this.getLabelControl().isDisposed()) {
            boolean enabled = this.getLabelAction() != null && this.getLabelAction().isEnabled();
            this.getLabelControl().setToolTipText(enabled ? this.getHyperlinkLableToolTip() : null);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.valueChangeListener != null && "field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            Object v = evt.getNewValue();
            this.valueProvider.removeValueChangeListener(this);
            this.setStringValue(v == null ? "" : v.toString());
            this.valueProvider.addValueChangeListener(this);
        }
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.getTextChangeControl(parent)};
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean isAlwaysReadOnly() {
        block4: {
            if (this.propertyEditor == null) {
                return false;
            }
            input = this.propertyEditor.getInput();
            if (!(input instanceof DefaultValueAdapter)) break block4;
            a = (DefaultValueAdapter)input;
            o = a.getModelObject();
            if (o != null && !o.isObjectEditable()) ** GOTO lbl10
            return false;
lbl-1000:
            // 1 sources

            {
                o = o.getParent();
lbl10:
                // 2 sources

                ** while (o != null && o.getFileType() < 2)
            }
lbl11:
            // 1 sources

            if (o == null) {
                return false;
            }
            entity = o.getModelEntity().getName();
            if (entity.indexOf("Jar") >= 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setStringValue(String value) {
        if (!this.isSameValue(value)) {
            super.setStringValue(value);
        }
    }

    boolean isSameValue(String newValue) {
        DefaultValueAdapter a;
        Text text = this.getTextField();
        if (text == null || text.isDisposed() || newValue == null) {
            return false;
        }
        String oldTextValue = text.getText();
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof DefaultValueAdapter && (a = (DefaultValueAdapter)this.propertyEditor.getInput()) != null && a.getAttribute() != null && a.getAttribute().isTrimmable()) {
            return oldTextValue != null && oldTextValue.trim().equals(newValue.trim());
        }
        return oldTextValue != null && oldTextValue.equals(newValue);
    }

    @Override
    protected void addContentAssist(Text text) {
        if (this.propertyEditor != null && this.propertyEditor.getInput() instanceof DefaultValueAdapter) {
            DefaultValueAdapter valueAdapter = (DefaultValueAdapter)this.propertyEditor.getInput();
            AttributeContentProposalProviderFactory.registerContentAssist(valueAdapter, (Control)text);
        }
    }
}

