/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.constraint.ConstraintEnforcer;
import org.jboss.forge.shell.constraint.ConstraintException;
import org.jboss.forge.shell.events.CommandExecuted;
import org.jboss.forge.shell.events.CommandMissing;
import org.jboss.forge.shell.exceptions.CommandExecutionException;
import org.jboss.forge.shell.plugins.AliasLiteral;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.util.Enums;
import org.mvel2.DataConversion;
import org.mvel2.util.ParseTools;

public class Execution {
    private final BeanManager manager;
    private CommandMetadata command;
    private Object[] parameterArray;
    private String originalStatement;
    private boolean scriptOnly;

    @Inject
    public Execution(BeanManager manager) {
        this.manager = manager;
    }

    public void verifyConstraints(Shell shell) {
        ConstraintEnforcer enforcer = new ConstraintEnforcer();
        if (this.command != null) {
            try {
                if (!this.command.isSetup()) {
                    enforcer.verifyAvailable(shell.getCurrentProject(), this.command.getParent());
                }
            }
            catch (ConstraintException e) {
                throw new CommandExecutionException(this.command, (Throwable)e);
            }
        }
    }

    public void perform(PipeOut pipeOut) {
        if (this.command != null) {
            CreationalContext context;
            Class pluginType = this.command.getParent().getType();
            Set beans = this.manager.getBeans((Type)pluginType, new Annotation[]{new AliasLiteral(this.command.getParent().getName())});
            Bean bean = this.manager.resolve(beans);
            Method method = this.command.getMethod();
            Class<?>[] parmTypes = method.getParameterTypes();
            Object[] paramStaging = new Object[this.parameterArray.length];
            for (int i = 0; i < parmTypes.length; ++i) {
                try {
                    if (parmTypes[i].isEnum()) {
                        paramStaging[i] = Enums.valueOf(parmTypes[i], this.parameterArray[i]);
                        continue;
                    }
                    paramStaging[i] = DataConversion.convert((Object)this.parameterArray[i], parmTypes[i]);
                    if (!Execution.isBooleanOption(parmTypes[i]) || null != paramStaging[i]) continue;
                    paramStaging[i] = false;
                    continue;
                }
                catch (Exception e) {
                    OptionMetadata option = this.command.getOptionByAbsoluteIndex(i);
                    String name = null;
                    name = option.isNamed() ? "--" + option.getName() : "at index [" + option.getIndex() + "]";
                    throw new CommandExecutionException(this.command, "command option '" + name + "' must be of type '" + parmTypes[i].getSimpleName() + "'", e);
                }
            }
            if (bean != null && (context = this.manager.createCreationalContext((Contextual)bean)) != null) {
                Plugin plugin = (Plugin)this.manager.getReference(bean, (Type)pluginType, context);
                CommandExecuted.Status status = CommandExecuted.Status.FAILURE;
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(plugin.getClass().getClassLoader());
                    this.command.getMethod().invoke((Object)plugin, paramStaging);
                    status = CommandExecuted.Status.SUCCESS;
                }
                catch (Exception e) {
                    throw new CommandExecutionException(this.command, (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                    this.manager.fireEvent((Object)new CommandExecuted(status, this.command, this.originalStatement, this.parameterArray), new Annotation[0]);
                }
            }
        } else {
            this.manager.fireEvent((Object)new CommandMissing(this.originalStatement, this.parameterArray), new Annotation[0]);
        }
    }

    private static boolean isBooleanOption(Class<?> type) {
        return ParseTools.unboxPrimitive(type) == Boolean.TYPE;
    }

    public CommandMetadata getCommand() {
        return this.command;
    }

    public void setCommand(CommandMetadata command) {
        this.command = command;
    }

    public boolean isScriptOnly() {
        return this.scriptOnly;
    }

    public void setScriptOnly(boolean scriptOnly) {
        this.scriptOnly = scriptOnly;
    }

    public Object[] getParameterArray() {
        return this.parameterArray;
    }

    public void setParameterArray(Object ... parameters) {
        this.parameterArray = parameters;
    }

    public String getOriginalStatement() {
        return this.originalStatement;
    }

    public void setOriginalStatement(String originalStatement) {
        this.originalStatement = originalStatement;
    }

    public String toString() {
        return "Execution [" + this.originalStatement + "]";
    }
}

