/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.HttpMethod;
import com.openshift.client.IHttpClient;
import com.openshift.client.utils.Base64Coder;
import com.openshift.internal.client.httpclient.BadRequestException;
import com.openshift.internal.client.httpclient.HttpClientException;
import com.openshift.internal.client.httpclient.IMediaType;
import com.openshift.internal.client.httpclient.InternalServerErrorException;
import com.openshift.internal.client.httpclient.NotFoundException;
import com.openshift.internal.client.httpclient.UnauthorizedException;
import com.openshift.internal.client.utils.StreamUtils;
import com.openshift.internal.client.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionHttpClient
implements IHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlConnectionHttpClient.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 10240;
    private static final int DEFAULT_READ_TIMEOUT = 61440;
    private static final String SYSPROP_OPENSHIFT_CONNECT_TIMEOUT = "com.openshift.httpclient.timeout";
    private static final String SYSPROP_DEFAULT_CONNECT_TIMEOUT = "sun.net.client.defaultConnectTimeout";
    private static final String SYSPROP_DEFAULT_READ_TIMEOUT = "sun.net.client.defaultReadTimeout";
    private static final String SYSPROP_ENABLE_SNI_EXTENSION = "jsse.enableSNIExtension";
    private static final String USERAGENT_FOR_KEYAUTH = "OpenShift";
    private String userAgent;
    private boolean sslChecks;
    private String username;
    private String password;
    private String authKey;
    private String authIV;
    private IMediaType requestMediaType;
    private String acceptedMediaType;
    private String version;

    public UrlConnectionHttpClient(String username, String password, String userAgent, boolean sslChecks, IMediaType requestMediaType, String acceptedMediaType, String version) {
        this(username, password, userAgent, sslChecks, requestMediaType, acceptedMediaType, version, null, null);
    }

    public UrlConnectionHttpClient(String username, String password, String userAgent, boolean sslChecks, IMediaType requestMediaType, String acceptedMediaType, String version, String authKey, String authIV) {
        this.username = username;
        this.password = password;
        this.userAgent = userAgent;
        this.sslChecks = sslChecks;
        this.requestMediaType = requestMediaType;
        this.acceptedMediaType = acceptedMediaType;
        this.authKey = authKey;
        this.authIV = authIV;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String get(URL url) throws HttpClientException, SocketTimeoutException {
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(this.username, this.password, this.authKey, this.authIV, this.userAgent, url);
            String string = StreamUtils.readToString(connection.getInputStream());
            this.disconnect(connection);
            return string;
        }
        catch (FileNotFoundException e) {
            try {
                throw new NotFoundException(MessageFormat.format("Could not find resource \"{0}\"", url.toString()), e);
                catch (IOException e2) {
                    throw this.createException(e2, connection);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String put(Map<String, Object> parameters, URL url) throws SocketTimeoutException, UnsupportedEncodingException, HttpClientException {
        return this.put(this.requestMediaType.encodeParameters(parameters), url);
    }

    protected String put(String data, URL url) throws HttpClientException, SocketTimeoutException {
        return this.write(data, HttpMethod.PUT.toString(), url);
    }

    @Override
    public String post(Map<String, Object> parameters, URL url) throws SocketTimeoutException, UnsupportedEncodingException, HttpClientException {
        return this.post(this.requestMediaType.encodeParameters(parameters), url);
    }

    protected String post(String data, URL url) throws HttpClientException, SocketTimeoutException {
        return this.write(data, HttpMethod.POST.toString(), url);
    }

    @Override
    public String delete(Map<String, Object> parameters, URL url) throws HttpClientException, SocketTimeoutException, UnsupportedEncodingException {
        return this.delete(this.requestMediaType.encodeParameters(parameters), url);
    }

    @Override
    public String delete(URL url) throws HttpClientException, SocketTimeoutException, UnsupportedEncodingException {
        return this.delete((String)null, url);
    }

    protected String delete(String data, URL url) throws HttpClientException, SocketTimeoutException {
        return this.write(data, HttpMethod.DELETE.toString(), url);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String write(String data, String requestMethod, URL url) throws SocketTimeoutException, HttpClientException {
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(this.username, this.password, this.authKey, this.authIV, this.userAgent, url);
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            if (data != null) {
                LOGGER.trace("Sending \"{}\" to {}", (Object)data, (Object)url);
                StreamUtils.writeTo(data.getBytes(), connection.getOutputStream());
            }
            String string = StreamUtils.readToString(connection.getInputStream());
            this.disconnect(connection);
            return string;
        }
        catch (FileNotFoundException e) {
            try {
                throw new NotFoundException(MessageFormat.format("Could not find resource {0}", url.toString()), e);
                catch (IOException e2) {
                    throw this.createException(e2, connection);
                }
            }
            catch (Throwable throwable) {
                this.disconnect(connection);
                throw throwable;
            }
        }
    }

    private void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    private HttpClientException createException(IOException ioe, HttpURLConnection connection) throws SocketTimeoutException {
        try {
            int responseCode = connection.getResponseCode();
            String errorMessage = StreamUtils.readToString(connection.getErrorStream());
            switch (responseCode) {
                case 200: {
                    return new InternalServerErrorException(errorMessage, ioe);
                }
                case 400: {
                    return new BadRequestException(errorMessage, ioe);
                }
                case 401: {
                    return new UnauthorizedException(errorMessage, ioe);
                }
                case 404: {
                    return new NotFoundException(errorMessage, ioe);
                }
            }
            return new HttpClientException(errorMessage, ioe);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            return new HttpClientException(e);
        }
    }

    private boolean isHttps(URL url) {
        return "https".equals(url.getProtocol());
    }

    private void setPermissiveSSLSocketFactory(HttpsURLConnection connection) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(new KeyManager[0], new TrustManager[]{new PermissiveTrustManager()}, new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            connection.setSSLSocketFactory(socketFactory);
        }
        catch (KeyManagementException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected HttpURLConnection createConnection(String username, String password, String userAgent, URL url) throws IOException {
        return this.createConnection(username, password, null, null, userAgent, url);
    }

    protected HttpURLConnection createConnection(String username, String password, String authKey, String authIV, String userAgent, URL url) throws IOException {
        LOGGER.trace("creating connection to {} using username \"{}\" and password \"{}\"", new Object[]{url, username, password});
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setSSLChecks(url, connection);
        this.setAuthorisation(username, password, authKey, authIV, connection);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setAllowUserInteraction(false);
        this.setConnectTimeout(connection);
        this.setReadTimeout(connection);
        connection.setInstanceFollowRedirects(true);
        this.setAcceptHeader(connection);
        this.setUserAgent(connection);
        connection.setRequestProperty("Content-Type", this.requestMediaType.getType());
        return connection;
    }

    private void setUserAgent(HttpURLConnection connection) {
        String userAgent = this.userAgent;
        if (!StringUtils.isEmpty(this.authKey)) {
            userAgent = USERAGENT_FOR_KEYAUTH;
        }
        if (userAgent != null) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private void setAcceptHeader(HttpURLConnection connection) {
        StringBuilder builder = new StringBuilder(this.acceptedMediaType);
        if (this.version != null) {
            builder.append(';').append(' ').append("version").append('=').append(this.version);
        }
        connection.setRequestProperty("Accept", builder.toString());
    }

    private void setAuthorisation(String username, String password, String authKey, String authIV, HttpURLConnection connection) {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            if (authKey != null && authIV != null) {
                connection.setRequestProperty("broker_auth_key", authKey);
                connection.setRequestProperty("broker_auth_iv", authIV);
            }
        } else {
            String credentials = Base64Coder.encodeString(username + ':' + password);
            connection.setRequestProperty("Authorization", "Basic" + ' ' + credentials);
        }
    }

    private void setSSLChecks(URL url, HttpURLConnection connection) {
        if (this.isHttps(url) && !this.sslChecks) {
            System.setProperty(SYSPROP_ENABLE_SNI_EXTENSION, "false");
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setHostnameVerifier(new NoopHostnameVerifier());
            this.setPermissiveSSLSocketFactory(httpsConnection);
        }
    }

    private void setConnectTimeout(URLConnection connection) {
        int timeout = this.getSystemPropertyInteger(SYSPROP_OPENSHIFT_CONNECT_TIMEOUT);
        if (timeout > -1) {
            connection.setConnectTimeout(timeout);
            return;
        }
        timeout = this.getSystemPropertyInteger(SYSPROP_DEFAULT_CONNECT_TIMEOUT);
        if (timeout == -1) {
            connection.setConnectTimeout(10240);
        }
    }

    private void setReadTimeout(URLConnection connection) {
        int timeout = this.getSystemPropertyInteger(SYSPROP_DEFAULT_READ_TIMEOUT);
        if (timeout == -1) {
            connection.setReadTimeout(61440);
        }
    }

    private int getSystemPropertyInteger(String key) {
        try {
            return Integer.parseInt(System.getProperty(key));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private class NoopHostnameVerifier
    implements HostnameVerifier {
        private NoopHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    }

    private class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

