# The JBoss Aerogear Tools Project

## Summary

JBoss Aerogear Tools contains tools for cross-platform mobile development. 

Currently the work is concentrated on providing [Apache Cordova](http://cordova.apache.org) tools for
hybrid mobile application development. Cordova tools provide Eclipse based tools for easing 
the development of Apache Cordova based hybrid mobile applications by hiding the complexities 
of multi-platform development and Cordova framewok.


## Install

Releases are yet to come! But you can get the nightly builds from staging p2 update site

> http://download.jboss.org/jbosstools/builds/staging/jbosstools-aerogear_master/all/repo/

### Requirements 
* [iOS SDK](http://developer.apple.com) with the latest Xcode including the Xcode Command Line Tools
* [Android SDK](http://developer.android.com) with the absolute latest updates for all Android SDK components. 

## Get the code

The easiest way to get started with the code is to [create your own fork](http://help.github.com/forking/), 
and then clone your fork:

    $ git clone git@github.com:<you>/jbosstools-aerogear.git
    $ cd jbosstools-aerogear
    $ git remote add upstream git@github.com:gorkem/jbosstools-aerogear.git
  
At any time, you can pull changes from the upstream and merge them onto your master:

    $ git checkout master               # switches to the 'master' branch
    $ git pull upstream master          # fetches all 'upstream' changes and merges 'upstream/master' onto your 'master' branch
    $ git push origin                   # pushes all the updates to your fork, which should be in-sync with 'upstream'

The general idea is to keep your 'master' branch in-sync with the
'upstream/master'.

## Building 

Building _JBoss Cordova tools_  requires specific versions of Java (1.6+) and
+Maven (3.1+). See this [link](https://github.com/jbosstools/jbosstools-devdoc/blob/master/building/readme.md) for more information on how to setup, run and configure build.

This command will run the build:

    $ mvn clean verify

If you just want to check if things compiles/builds you can run:

    $ mvn clean verify -DskipTest=true

But *do not* push changes without having the new and existing unit tests pass!
 
## Contribute fixes and features

_JBoss Cordova Tools_ is open source, and we welcome anybody that wants to
participate and contribute!

If you want to fix a bug or make any changes, please log an issue in
the [JBoss Tools JIRA](https://issues.jboss.org/browse/JBIDE)
describing the bug or new feature and give it a component type of
`aerogear-hybrid`. Then we highly recommend making the changes on a
topic branch named with the JIRA issue number. For example, this
command creates a branch for the JBIDE-1234 issue:

	$ git checkout -b jbide-1234

After you're happy with your changes and a full build (with unit
tests) runs successfully, commit your changes on your topic branch
(with good comments). Then it's time to check for any recent changes
that were made in the official repository:

	$ git checkout master               # switches to the 'master' branch
	$ git pull upstream master          # fetches all 'upstream' changes and merges 'upstream/master' onto your 'master' branch
	$ git checkout jbide-1234           # switches to your topic branch
	$ git rebase master                 # reapplies your changes on top of the latest in master
	                                      (i.e., the latest from master will be the new base for your changes)

If the pull grabbed a lot of changes, you should rerun your build with
tests enabled to make sure your changes are still good.

You can then push your topic branch and its changes into your public fork repository:

	$ git push origin jbide-1234         # pushes your topic branch into your public fork of JBoss Central

And then [generate a pull-request](http://help.github.com/pull-requests/) where we can
review the proposed changes, comment on them, discuss them with you,
and if everything is good merge the changes right into the official
repository.
