/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport.backchannel;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.transport.RMUnMarshaller;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMBackPortsInvocationHandler;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandler;

public final class RMBackPortsServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(RMBackPortsServer.class);
    private static final Lock CLASS_LOCK = new ReentrantLock();
    private static final long WAIT_PERIOD = 100L;
    private static RMBackPortsServer INSTANCE;
    private final Object instanceLock = new Object();
    private final Connector connector;
    private final String scheme;
    private final String host;
    private final int port;
    private RMBackPortsInvocationHandler handler;
    private boolean started;
    private boolean stopped;
    private boolean terminated;

    public final void registerCallback(RMCallbackHandler callbackHandler) {
        this.handler.registerCallback(callbackHandler);
    }

    public final void unregisterCallback(RMCallbackHandler callbackHandler) {
        this.handler.unregisterCallback(callbackHandler);
    }

    public final RMCallbackHandler getCallback(String requestPath) {
        return this.handler.getCallback(requestPath);
    }

    private RMBackPortsServer(String scheme, String host, int port) throws RMException {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        try {
            String customUnmarshaller = "/?unmarshaller=" + RMUnMarshaller.class.getName();
            InvokerLocator il = new InvokerLocator(this.scheme + "://" + this.host + ":" + this.port + customUnmarshaller);
            this.connector = new Connector();
            this.connector.setInvokerLocator(il.getLocatorURI());
            this.connector.create();
            this.handler = new RMBackPortsInvocationHandler();
            this.connector.addInvocationHandler("wsrmBackPortsHandler", (ServerInvocationHandler)this.handler);
            this.connector.start();
            LOG.debug((Object)("WS-RM Backports Server started on: " + il.getLocatorURI()));
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new RMException(e.getMessage(), e);
        }
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            while (!this.stopped) {
                try {
                    this.instanceLock.wait(100L);
                    LOG.debug((Object)"serving requests");
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)ie.getMessage(), (Throwable)ie);
                }
            }
            try {
                this.connector.stop();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                LOG.debug((Object)"terminated");
                this.terminated = true;
                throw throwable;
            }
            LOG.debug((Object)"terminated");
            this.terminated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminate() {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            LOG.debug((Object)"termination forced");
            while (!this.terminated) {
                try {
                    LOG.debug((Object)"waiting for termination");
                    this.instanceLock.wait(100L);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)ie.getMessage(), (Throwable)ie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RMBackPortsServer getInstance(String scheme, String host, int port) throws RMException {
        CLASS_LOCK.lock();
        try {
            if (INSTANCE == null) {
                INSTANCE = new RMBackPortsServer(scheme, host, port == -1 ? 80 : port);
                Thread t = new Thread((Runnable)INSTANCE, "RMBackPortsServer");
                t.setDaemon(true);
                t.start();
                final RMBackPortsServer server = INSTANCE;
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    public void run() {
                        server.terminate();
                    }
                }, "RMBackPortsServerShutdownHook"));
            } else {
                boolean portEquals;
                boolean schemeEquals = INSTANCE.getScheme().equals(scheme);
                boolean hostEquals = INSTANCE.getHost().equals(host);
                boolean bl = portEquals = INSTANCE.getPort() == (port == -1 ? 80 : port);
                if (!(schemeEquals && hostEquals && portEquals)) {
                    throw new IllegalArgumentException();
                }
            }
            RMBackPortsServer rMBackPortsServer = INSTANCE;
            Object var7_8 = null;
            CLASS_LOCK.unlock();
            return rMBackPortsServer;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            CLASS_LOCK.unlock();
            throw throwable;
        }
    }
}

