/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;

public class MethodBindingMethodExpressionAdapter
extends MethodBinding
implements StateHolder,
Serializable {
    private static final long serialVersionUID = 6351778415298720238L;
    private MethodExpression methodExpression = null;
    private boolean tranzient;

    public MethodBindingMethodExpressionAdapter() {
    }

    public MethodBindingMethodExpressionAdapter(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public Object invoke(FacesContext context, Object[] params) throws EvaluationException, javax.faces.el.MethodNotFoundException {
        assert (null != this.methodExpression);
        if (context == null) {
            throw new NullPointerException("FacesConext -> null");
        }
        Object result = null;
        try {
            result = this.methodExpression.invoke(context.getELContext(), params);
        }
        catch (MethodNotFoundException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        catch (PropertyNotFoundException e) {
            throw new EvaluationException(e);
        }
        catch (ELException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new EvaluationException(cause);
        }
        catch (NullPointerException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        return result;
    }

    public Class getType(FacesContext context) throws javax.faces.el.MethodNotFoundException {
        assert (null != this.methodExpression);
        if (context == null) {
            throw new NullPointerException("FacesConext -> null");
        }
        Class result = null;
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            MethodInfo mi = this.methodExpression.getMethodInfo(context.getELContext());
            result = mi.getReturnType();
        }
        catch (PropertyNotFoundException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        catch (MethodNotFoundException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        catch (ELException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        return result;
    }

    public String getExpressionString() {
        assert (null != this.methodExpression);
        return this.methodExpression.getExpressionString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MethodBindingMethodExpressionAdapter) {
            return this.methodExpression.equals((Object)((MethodBindingMethodExpressionAdapter)other).getWrapped());
        }
        if (other instanceof MethodBinding) {
            Method[] methods;
            MethodBinding binding = (MethodBinding)other;
            String expr = binding.getExpressionString();
            int idx = expr.indexOf(46);
            String target = expr.substring(0, idx).substring(2);
            String t = expr.substring(idx + 1);
            String method = t.substring(0, t.length() - 1);
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            MethodInfo controlInfo = this.methodExpression.getMethodInfo(elContext);
            if (!controlInfo.getName().equals(method)) {
                return false;
            }
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            ValueExpression ve = factory.createValueExpression(elContext, "#{" + target + '}', Object.class);
            if (ve == null) {
                return false;
            }
            Object result = ve.getValue(elContext);
            if (result == null) {
                return false;
            }
            Class type = binding.getType(context);
            for (Method meth : methods = result.getClass().getMethods()) {
                if (!meth.getName().equals(method) || !type.equals(controlInfo.getReturnType()) || !Arrays.equals(meth.getParameterTypes(), controlInfo.getParamTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        assert (null != this.methodExpression);
        return this.methodExpression.hashCode();
    }

    public boolean isTransient() {
        return this.tranzient;
    }

    public void setTransient(boolean tranzient) {
        this.tranzient = tranzient;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] result = null;
        if (!this.tranzient) {
            if (this.methodExpression instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)this.methodExpression).saveState(context), this.methodExpression.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.methodExpression;
            }
        }
        return result;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodExpression)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodExpression result = null;
            Class toRestoreClass = null;
            if (null != className) {
                try {
                    toRestoreClass = MethodBindingMethodExpressionAdapter.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodExpression)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)result).restoreState(context, savedState);
                }
                this.methodExpression = result;
            }
        } else {
            this.methodExpression = (MethodExpression)state;
        }
    }

    public MethodExpression getWrapped() {
        return this.methodExpression;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, true, loader);
    }
}

