/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ClassNotFoundException {
        ClassLoader classLoader;
        block17: {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception x) {
                throw new ClassNotFoundException(x.toString(), x);
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                if (is != null) {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        return FactoryFinder.newInstance(factoryClassName, classLoader);
                    }
                }
            }
            catch (IOException ex) {
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                String javah = System.getProperty("java.home");
                String configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
                File f = new File(configFile);
                if (!f.exists()) break block17;
                Properties props = new Properties();
                FileInputStream is = new FileInputStream(f);
                try {
                    props.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
                String factoryClassName = props.getProperty(factoryId);
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
            catch (IOException ex) {
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }
}

