/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.SecurityElement;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Timestamp
implements SecurityElement {
    private String id = "timestamp";
    private Integer ttl;
    private Document doc;
    private Calendar created;
    private Calendar expires;
    private Element cachedElement;

    public Timestamp(Integer ttl, Document doc) {
        this.doc = doc;
        this.ttl = ttl;
    }

    public Timestamp(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            throw new WSSecurityException("Invalid message, Timestamp is missing an id");
        }
        this.id = id;
        Element child = Util.getFirstChildElement(element);
        if (child == null || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(child.getNamespaceURI()) || !"Created".equals(child.getLocalName())) {
            throw new WSSecurityException("Created child expected in Timestamp element");
        }
        this.created = SimpleTypeBindings.unmarshalDateTime((String)XMLUtils.getFullTextChildrenFromElement((Element)child));
        if ((child = Util.getNextSiblingElement(child)) == null) {
            return;
        }
        this.expires = SimpleTypeBindings.unmarshalDateTime((String)XMLUtils.getFullTextChildrenFromElement((Element)child));
    }

    private void setupTime() {
        this.created = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        if (this.ttl != null) {
            this.expires = (Calendar)this.created.clone();
            this.expires.add(13, this.ttl);
        }
    }

    private String getId() {
        return this.id;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public Element getElement() throws WSSecurityException {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        this.setupTime();
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.getId());
        Element child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        child.appendChild(this.doc.createTextNode(SimpleTypeBindings.marshalDateTime((Calendar)this.created)));
        element.appendChild(child);
        if (this.expires != null) {
            child = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
            child.appendChild(this.doc.createTextNode(SimpleTypeBindings.marshalDateTime((Calendar)this.expires)));
            element.appendChild(child);
        }
        this.cachedElement = element;
        return this.cachedElement;
    }
}

