"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
const flags_1 = require("@oclif/parser/lib/flags");
exports.cheNamespace = flags_1.string({
    char: 'n',
    description: 'Kubernetes namespace where CodeReady Workspaces server is supposed to be deployed',
    default: 'workspaces',
    env: 'CHE_NAMESPACE'
});
exports.cheDeployment = flags_1.string({
    description: 'CodeReady Workspaces deployment name',
    default: 'codeready',
    env: 'CHE_DEPLOYMENT'
});
exports.listrRenderer = flags_1.string({
    description: 'Listr renderer',
    options: ['default', 'silent', 'verbose'],
    default: 'default'
});
exports.accessToken = flags_1.string({
    description: 'CodeReady Workspaces OIDC Access Token',
    env: 'CHE_ACCESS_TOKEN'
});
//# sourceMappingURL=common-flags.js.map